/* 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;  File: chartohex.c
;;;  Author: Trevor Darrell
;;;  Description: convert 8bit arrays to hex for postscript output
;;;  Creation Date: Nov '88
;;;  ----------------------------------------------------------------
;;;    Object-Based Vision and Image Understanding System (OBVIUS),
;;;      Copyright 1988, Vision Science Group,  Media Laboratory,  
;;;              Massachusetts Institute of Technology.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
*/

# include <stdio.h>
# include <sys/file.h>
#ifndef O_WRONLY      /* SYS_V */
# include <fcntl.h>
#endif

unsigned char hextab[] = "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff";

internal_chartohex(path, image, xs, ys, buffer)
char *path;             /* name of file to write image into */
unsigned char *image;   /* unsigned character image data */
int xs, ys; 		/* size of image data in pixels */
unsigned char *buffer; 	/* buffer for each line of data: size = (2 * xs) + 1 */
{               


  int     x, y;
  int	bytesleft;
  unsigned char	*hex, *bp, *buf;
  int     fd;
  int     bufsz = xs * 2 + 1;

  fd = open(path, O_WRONLY);
  if (fd < 0) {
    fputs("Couldn't append to postscript file\n", stderr);
    return -1;
  }
  lseek(fd, 0, L_XTND);

  for (bp = image, y = 0; y < ys; ++y) {
    for (buf = buffer, x = 0; x < xs; ++x, ++bp) {
      hex = &(hextab[(*bp * 2)]);
      *buf++ = *hex++;
      *buf++ = *hex++;
    }
    *buf = '\n';
    write(fd, buffer, bufsz);
  }
  close(fd);
  return 0;
}


/* Local Variables: */
/* buffer-read-only: t */
/* End: */

