(in-package 'xtile)

(export '(run))

(defun run (&optional *display-on* experiment-name)
  (cond ((stringp experiment-name)
	 (format t "Loading ~s as the experiment-definition file.~&"
		 experiment-name)
	 (load-experiment-file experiment-name)
	 )	;Assume strings are filenames for loading experiment-lists
	((null experiment-name)
	 (if (and (boundp '*experiment-file-name*) *experiment-file-name*)
	     (progn (format t ";;; Loading previous experiment file.~&"
			    *experiment-file-name*)
		    (load *experiment-file-name*))
             (progn (format t "Loading default experiment file.~&")
                    (load-experiment-file "default.exper.lisp"))))
	((format t "WARNING: Ignoring invalid experiment-name.~&")))
  (if (null *experiment-list*)
      (format t "Can't run - no list of experiments to do.~&")
      (if *display-on*
          (xtw-with-open-display
           '(xtw-with-ui-defaults
             '(xtw-with-experiment-ui
               '(xtw-with-world-ui
                 '(xtw-with-agent-ui
                   '(xtw-main-loop))))))
          (experiment-with-no-display))))
          
(defun experiment-with-no-display ()
  (let ((*exper-dialog* nil)
	(*keephistory* nil)   ;history stuff is not really part of the ui,
	(*history* nil)
	(*historyfile* nil)
        (*quit* nil))   ;but we have noplace better for it.
    (post-load)
    (start-game)
    (do ()(*quit*)(xtw-step))
    (close-history-if-open)))

(defun start-game ()
  (when *display-on*
    (xtw-ui-reset))
  (xtw-start-experiment)
  (format t ";;;   Starting a game. seed:~s~%" *world-rand-seed*))



