/*
 * priority queue (heap) package.
 *
 * Bsy, 9/86.
 *
 * Made expandable: mnr, 6/20/88, 7/4/88
 */

#include "heap.h"
/* #include "/usr/cs/include/libc.h" */	/* malloc gets etc */
/* #include "usegc.h"*/

#define	PARENT(i)	((i-1)>>2)
#define	CHILD(i)	((i<<2) + 1)	/* first child */

/*
 * priority queue (heap) package.
 *
 * Bsy, 9/86.
 */

heap	*hp_make(func,startsize)
int	(*func)(), startsize;
{
	register heap	*p;

	if (p = (heap *) malloc(sizeof(heap))) {
		if (p->hp_heap = (char **) malloc((unsigned) startsize * sizeof(char *))) {
			p->hp_size	= startsize;
			p->hp_func	= func;
			p->hp_nxt	= 0;
		} else {
		  free((char *) p);
			p		= 0;
		}
	}
	return p;
}

int hp_enter(hp,elt)
register heap	*hp;
char		*elt;
{
	register int	new, parent, size, i;
	char		**p;

	if ((new = hp->hp_nxt) >= hp->hp_size) {  /* expand the heap */
		size=(hp->hp_size * 3) / 2;
		if (p = (char **) realloc(hp->hp_heap,size * sizeof(char *))) {
			hp->hp_size	= size;
			hp->hp_heap=p;
		} else {
		    return 0;
		}
	}
	while (new > 0 && hp->hp_func(hp->hp_heap[parent = PARENT(new)],elt) > 0) {
		hp->hp_heap[new]	= hp->hp_heap[parent];
		new			= parent;
	}
	hp->hp_heap[new]	= elt;
	hp->hp_nxt++;
	return 1;
}

char *hp_delmin(hp)
register heap	*hp;
{
	char		*elt = hp->hp_heap[0], *last_elt;
	int		cur, offset, hp_end;
	register int	(*fp)() = hp->hp_func, min, next;

	if (hp->hp_nxt == 0) return 0;
	cur		= 0;
	last_elt	= hp->hp_heap[hp_end = --hp->hp_nxt];
	while ((offset = hp_end - (next = CHILD(cur))) > 0) {
		min = next;
		switch (offset) {
		case 4:
all:			if ((*fp)(hp->hp_heap[min],hp->hp_heap[next+3]) > 0) min = next+3;
		case 3:	if ((*fp)(hp->hp_heap[min],hp->hp_heap[next+2]) > 0) min = next+2;
		case 2:	if ((*fp)(hp->hp_heap[min],hp->hp_heap[next+1]) > 0) min = next+1;
		case 1:	break;
		default:	goto all;
		}
		if ((*fp)(hp->hp_heap[min],last_elt) < 0)
			hp->hp_heap[cur] = hp->hp_heap[min];
		else	goto done;
		cur = min;
	}
done:	hp->hp_heap[cur] = last_elt;
	return elt;
}
