(require 'loop)
(use-package :loop)

(defvar *tileworld-dir* "~/tileworld/new-tile/xtile")
(defvar *tileworld-basics-dir* "~/tileworld/new-tile/xtile/basics")
(defvar *tileworld-exper-dir* "~/tileworld/new-tile/xtile/exper")
(defvar *tileworld-extensions-dir* "~/tileworld/new-tile/xtile/extensions")
(defvar *tileworld-world-dir* "~/tileworld/new-tile/xtile/world")
(defvar *tileworld-agent-dir* "~/tileworld/new-tile/xtile/agent")
(defvar *tileworld-environments-dir* "~/tileworld/new-tile/xtile/environments")

(defun load-file-with-dir (dir file)
  (load (merge-pathnames (make-pathname :directory dir)
						 (make-pathname :name file))))

(defun load-file-list-with-dir (dir file-list)
  (cond
   ((null file-list) (values))
   (t (load-file-with-dir dir (car file-list))
	  (load-file-list-with-dir dir (cdr file-list)))))

(defun load-files-with-dir (dir &rest files)
  (load-file-list-with-dir dir files))

(defun load-basics ()
  (load-files-with-dir *tileworld-basics-dir* 
                       "common"
                       "defvar"
                       ))

(defun load-exper ()
  (load-files-with-dir *tileworld-exper-dir* 
                       "save-history"
                       "logging"
                       "exper"
                       "exper-save"
                       ))

(defun load-agent ()
  (load-files-with-dir *tileworld-agent-dir*
                       "agent-structures"
                       "agent-access"
                       "agent"
                       "agent-main"
                       "pplan"
                       "foreigndefs"
                       ))

(defun load-world ()
  (load-files-with-dir *tileworld-world-dir* 
                       "tw"
                       "world"
                       ))

(defun load-extensions ()
  (load-files-with-dir *tileworld-extensions-dir* 
                       "agent-optimal"
                       "no-display"
                       "spplan"
                       ))

(defun load-all () 
  (load "~/tileworld/new-tile/cl-util/defsystem")
  (load-basics)
  (load-exper)
  (load-agent)
  (load-world)
  (load-extensions))
    
(load-all)
(use-package '(xtile))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Compile code

(defun compile-file-with-dir (dir file)
  (compile-file (merge-pathnames (make-pathname :directory dir)
						 (make-pathname :name file))))

(defun compile-file-list-with-dir (dir file-list)
  (cond
   ((null file-list) (values))
   (t (compile-file-with-dir dir (car file-list))
	  (compile-file-list-with-dir dir (cdr file-list)))))

(defun compile-files-with-dir (dir &rest files)
  (compile-file-list-with-dir dir files))

                          