/**************************************************************************/
/* main.h                                                       /\/\      */
/* Version 2.2.1 --  August  1991                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _main_h
#define _main_h

#include "global_simmel.h"


#ifndef MAIN_EXTERN
#	define MAIN_EXTERN extern
#endif



/*
 * From which file to read the D-H matrix.
 */
#define DHfile	"DHfile"



/*
 * Global: the camera view.  The position of the end-effector
 * as observed by fixed cameras 1 and 2:
 */
MAIN_EXTERN vector cam_1_eef, cam_2_eef;
/*
 * The position of the object as observed by cameras 1 and 2:
 */
MAIN_EXTERN vector cam_1_obj, cam_2_obj;
/*
 * The position and area of the object as seen by the hand camera:
 */
MAIN_EXTERN vector hand_camera, area;
/*
 * Global: the position of the end-effector.  Also known
 * as end-effectuator, which is more characters.
 */
MAIN_EXTERN vector effector;


/*
 * The positions (DH matrices) of fixed cameras #1 and #2.
 */
MAIN_EXTERN homo cam_1_inv_homo, cam_2_inv_homo;


void main(int argc, char *argv[]);
void test_simulator(void);

#endif
