/**************************************************************************/
/* matrix.h --- after a version by F. J. Jungen                 /\/\      */
/* Version 2.2.1 --  January 1992                               \  /      */
/*                                                              /  \      */
/* Author: P. Patrick van der Smagt                          _  \/\/  _   */
/*         University of Amsterdam                          | |      | |  */
/*         Dept. of Computer Systems                        | | /\/\ | |  */
/*         Amsterdam                                        | | \  / | |  */
/*         THE NETHERLANDS                                  | | /  \ | |  */
/*         smagt@fwi.uva.nl                                 | | \/\/ | |  */
/*                                                          | \______/ |  */
/* This software has been written with financial             \________/   */
/* support of the Dutch Foundation for Neural Networks                    */
/* and is therefore owned by the mentioned foundation.          /\/\      */
/*                                                              \  /      */
/*                                                              /  \      */
/*                                                              \/\/      */
/**************************************************************************/
#ifndef _matrix_h
#define _matrix_h


#define		HOMO_DEG	4


typedef REAL homo[HOMO_DEG*HOMO_DEG];
typedef REAL *matrix;


void init_matrix(REAL *M, int rows, int columns);
void mul_matrix(matrix A, int a_rows, int a_columns,
		matrix B, int b_rows, int b_columns,
		matrix C, int c_rows, int c_columns);
void perspective_transform(homo M, REAL focus);
void viewpoint_transform(homo V, REAL theta, REAL angle, REAL distance);
void dh_transformation(homo M, REAL theta, REAL d, REAL a, REAL alfa);
void invert_homo(homo HI, homo H);
void copy_homo(homo D, homo s);
void print_matrix(homo H);

#endif
