#define MAX_BUTTONS			100
#define MAX_SLIDEBARS 		100
#define MAX_ARROWS			100

#define MAXSLIDEBARLENGTH 	512
#define SLIDEBARHEIGHT 		30

#define TEXT_COLOUR 0x00ffffff
#define BORDER_COLOUR 0x007c7c7c

#define slidebar_position(p) (((double)((p)->pos-5))/((double)((p)->length-10-(p)->thumb)))

#define position_slidebar(p,v) ((p)->pos=5+(v)*((double)((p)->length-10-(p)->thumb)))

typedef struct {
    int xstart,ystart;
    int width,height;
    long rgb;
    long textrgb;
    char *text;
    int textxoff,textyoff;
    void (*runfunc)();      	/* This is called when first pressed */
    void (*actionfunc)();       /* Is called when button released */
    } BUTTON;

typedef struct {
	int xstart,ystart;
	int length;
	int pos;
	int thumb;
	long rgb;
	void (*runfunc)();			/* Is called whilst button down */
	void (*actionfunc)();		/* Is called when slidebar released */
	} SLIDEBAR;

typedef struct {
	int x,y;
	float a;
	long rgb;
	long back_rgb;
	void (*runfunc)();		/* Is called whilst button down */
	void (*actionfunc)();		/* Is called when slidebar released */
	} ARROW;

int find_slidebar();
int find_arrow();

extern ARROW *arrow[MAX_ARROWS];
extern int numarrows;
extern SLIDEBAR *slidebar[MAX_SLIDEBARS];
extern int numslidebars;
extern BUTTON *button[MAX_BUTTONS];
extern int numbuttons;

int create_arrow();
int create_slidebar();
int create_button();

extern int jnum;
