/******************************************************************************\
********************************************************************************
********                                                                ********
******      Robot Simulator                                               ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          WINDOWLIB.C                                                       **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#ifdef R_SGI
#include <gl.h>
#include <device.h>
#endif
#include <string.h>
#include <stdio.h>
#include <malloc.h>
#include <sys/types.h>
#include <math.h>
#include "windowlib.h"
#include "rob.h"

#ifndef R_SGI
#define fcos(a) ((double)cos(a))
#define fsin(a) ((double)sin(a))
#endif

#define min(a,b) ((a)<(b)?(a):(b))

SLIDEBAR *slidebar[MAX_SLIDEBARS];
int numslidebars;
ARROW *arrow[MAX_ARROWS];
int numarrows;
BUTTON *button[MAX_BUTTONS];
int numbuttons;

int tl_index[100];	/* top left index 0-background, */
int bl_index[100];	/* bottom left index 0-background, */
int tr_index[100];	/* top right index 0-background, */
int br_index[100];	/* bottom right index 0-background, */

void init_tl_index()
{
	FILE *in;
	int i,j;

	in=fopen("index.tl","r");
	if(!in) {
		printf("Cannot load index file\n");
		exit(0);
	}
	for(j=0;j<10;j++) {
		for(i=0;i<10;i++) {
			fscanf(in," %d",&(tl_index[i+(9-j)*10]));
		}
	}
	fclose(in);
}

void init_bl_index()
{
    FILE *in;
    int i,j;

    in=fopen("index.bl","r");
    if(!in) {
        printf("Cannot load index file\n");
        exit(0);
    }
    for(j=0;j<10;j++) {
        for(i=0;i<10;i++) {
            fscanf(in," %d",&(bl_index[i+(9-j)*10]));
        }
    }
    fclose(in);
}

void init_tr_index()
{
    FILE *in;
    int i,j;

    in=fopen("index.tr","r");
    if(!in) {
        printf("Cannot load index file\n");
        exit(0);
    }
    for(j=0;j<10;j++) {
        for(i=0;i<10;i++) {
            fscanf(in," %d",&(tr_index[i+(9-j)*10]));
        }
    }
    fclose(in);
}

void init_br_index()
{
    FILE *in;
    int i,j;

    in=fopen("index.br","r");
    if(!in) {
        printf("Cannot load index file\n");
        exit(0);
    }
    for(j=0;j<10;j++) {
        for(i=0;i<10;i++) {
            fscanf(in," %d",&(br_index[i+(9-j)*10]));
        }
    }
    fclose(in);
}

void exit_error(s)
char *s;
{	
	printf("%s\n",s);
	exit(0);
}

void fill_tl_corner(a,w,c,bc)
long *a;
long c,bc;
int w;
{
	int i,j;
	
	for(i=0;i<10;i++) {
		for(j=0;j<10;j++) {
			if(tl_index[i+10*j]==0) {
				a[i+w*j]=bc;
			} else {
				a[i+w*j]=(c*(tl_index[i+10*j]-1))/4;
			}
		}
	}
}

void fill_bl_corner(a,w,c,bc)
long *a;
long c,bc;
int w;
{
    int i,j;
    
	for(i=0;i<10;i++) {
        for(j=0;j<10;j++) {
            if(bl_index[i+10*j]==0) {
                a[i+w*j]=bc;
            } else {
                a[i+w*j]=(c*(bl_index[i+10*j]-1))/4;
            }
        }
    }
}

void fill_tr_corner(a,w,c,bc)
long *a;
long c,bc;
int w;
{
    int i,j;
    
	for(i=0;i<10;i++) {
        for(j=0;j<10;j++) {
            if(tr_index[i+10*j]==0) {
                a[i+w*j]=bc;
            } else {
                a[i+w*j]=(c*(tr_index[i+10*j]-1))/4;
            }
        }
    }
}

void fill_br_corner(a,w,c,bc)
long *a;
long c,bc;
int w;
{
    int i,j;
    
	for(i=0;i<10;i++) {
        for(j=0;j<10;j++) {
            if(br_index[i+10*j]==0) {
                a[i+w*j]=bc;
            } else {
                a[i+w*j]=(c*(br_index[i+10*j]-1))/4;
            }
        }
    }
}

void rfill_array(x,y,a,c,bc)	/* rounded corners */
int x,y;
long c,bc;	/* colour and background colour */
long *a;
{
    int i,j;

    for(i=0;i<x;i++) {
        for(j=0;j<y;j++) {
            a[j*x+i]=c;
        }
    }
    for(i=0;i<4;i++) {
        for(j=i;j<(y-i);j++) {
            a[j*x+i]=(c*2)-(i+1)*(c/4);
            a[j*x+x-1-i]=i*(c/4);
        }
    }
    for(j=0;j<4;j++) {
        for(i=j;i<(x-j);i++) {
            a[j*x+i]=j*(c/4);
            a[(y-j-1)*x+i]=(c*2)-(j+1)*(c/4);
        }
    }
	fill_tl_corner(&(a[x*(y-10)]),x,c,bc);
	fill_bl_corner(&(a[0]),x,c,bc);
	fill_tr_corner(&(a[x*(y-10)+(x-10)]),x,c,bc);
	fill_br_corner(&(a[x-10]),x,c,bc);
}

void fill_array(x,y,a,c)
int x,y;
long c;
long *a;
{
	int i,j;

	for(i=0;i<x;i++) {
		for(j=0;j<y;j++) {
			a[j*x+i]=c;
		}
	}
	for(i=0;i<4;i++) {
		for(j=i;j<(y-i);j++) {
			a[j*x+i]=(c*2)-(i+1)*(c/4);
			a[j*x+x-1-i]=i*(c/4);
		}
	}
	for(j=0;j<4;j++) {
		for(i=j;i<(x-j);i++) {
			a[j*x+i]=j*(c/4);
			a[(y-j-1)*x+i]=(c*2)-(j+1)*(c/4);
		}
	}
}

void fill_invarray(x,y,a,c)
int x,y;
long c;
long *a;
{
	int i,j;

	for(i=0;i<x;i++) {
		for(j=0;j<y;j++) {
			a[j*x+i]=c;
		}
	}
	for(i=0;i<4;i++) {
		for(j=i;j<(y-i);j++) {
			a[j*x+i]=i*(c/4);
			a[j*x+x-1-i]=(c*2)-(i+1)*(c/4);
		}
	}
	for(j=0;j<4;j++) {
		for(i=j;i<(x-j);i++) {
			a[j*x+i]=(c*2)-(j+1)*(c/4);
			a[(y-j-1)*x+i]=j*(c/4);
		}
	}
}

int create_button(x,y,w,h,rgb,text,rf,af)
int x,y,w,h;    
long rgb;
char *text;
void (*af)();
void (*rf)();
{
    BUTTON *bptr;

    if(!(bptr=(BUTTON *)calloc(1,sizeof(BUTTON)))) exit_error("windowlib.c : Memory allocation error");
    bptr->xstart=x;
    bptr->ystart=y;
    bptr->width=w;
    bptr->height=h;
    bptr->textxoff=10;
    bptr->textyoff=10;
    bptr->text=text;
    bptr->rgb=rgb;
    bptr->textrgb=TEXT_COLOUR;
    bptr->runfunc=rf;
    bptr->actionfunc=af;
	button[numbuttons]=bptr;
	numbuttons++;
    return(numbuttons-1);
}

int create_slidebar(x,y,l,pos,thumb,c,rf,af) 
int x,y,l,thumb,pos;
long c;
void (*rf)();	/* Run function - calls whilst moving */
void (*af)();	/* Action function - call when deselected */
{
	SLIDEBAR *sptr;

	if(!(sptr=(SLIDEBAR *)calloc(1,sizeof(SLIDEBAR)))) exit_error("windowlib.c: memory allocation error");
	sptr->xstart=x;
	sptr->ystart=y;
	sptr->length=l;
	sptr->pos=pos;
	sptr->thumb=thumb;
	sptr->rgb=c;
	sptr->runfunc=rf;
	sptr->actionfunc=af;
	slidebar[numslidebars]=sptr;
	numslidebars++;
	return(numslidebars-1);
}

int create_arrow(x,y,a,c,rf,af)	
int x,y;
long c;
float a;
void (*rf)();
void (*af)();
{
	ARROW *aptr;

	if(!(aptr=(ARROW *)calloc(1,sizeof(ARROW)))) exit_error("windowlib.c: memory allocation error");
	aptr->x=x;
	aptr->y=y;
	aptr->a=a;
	aptr->rgb=c;
	aptr->runfunc=rf;
	aptr->actionfunc=af;
	arrow[numarrows]=aptr;
	numarrows++;
	return(numarrows-1);
}

void draw_button(bptr)
BUTTON *bptr;
{
    int i,j;
    long *a;
    a=(long *)calloc(bptr->width*bptr->height,sizeof(long));
    if(!a) exit_error("windowlib.c : memory allocation error");
    fill_array(bptr->width,bptr->height,a,bptr->rgb);
#ifdef R_SGI
    lrectwrite(bptr->xstart,bptr->ystart,bptr->xstart+bptr->width-1,bptr->ystart+bptr->height-1,a);
	if(bptr->text) {
	    cpack(bptr->textrgb);
   	 	cmov2(bptr->xstart+bptr->textxoff,bptr->ystart+bptr->textyoff);
   	 	charstr(bptr->text);
	}
#endif
    free(a);
}

void draw_invbutton(bptr) 
BUTTON *bptr;
{
    int i,j;
    long *a;

	a=(long *)calloc(bptr->width*bptr->height,sizeof(long));
	if(!a) exit_error("windowlib.c : memory allocation error");
	fill_invarray(bptr->width,bptr->height,a,bptr->rgb);
#ifdef R_SGI
	lrectwrite(bptr->xstart,bptr->ystart,bptr->xstart+bptr->width-1,bptr->ystart+bptr->height-1,a);
	if(bptr->text) {
		cpack(bptr->textrgb);
		cmov2(bptr->xstart+bptr->textxoff+2,bptr->ystart+bptr->textyoff-1);
		charstr(bptr->text);
	}
#endif
	free(a);
}

void draw_slidebar(sptr)
SLIDEBAR *sptr;
{
	unsigned long a[MAXSLIDEBARLENGTH*SLIDEBARHEIGHT];

#ifdef R_SGI
	fill_array(sptr->length,SLIDEBARHEIGHT,a,sptr->rgb);
	lrectwrite(sptr->xstart,sptr->ystart,sptr->xstart+sptr->length-1,sptr->ystart+SLIDEBARHEIGHT-1,a);
	fill_array(sptr->thumb,SLIDEBARHEIGHT-10,a,sptr->rgb);
	lrectwrite(sptr->xstart+sptr->pos,sptr->ystart+5,sptr->xstart+sptr->pos+sptr->thumb-1,sptr->ystart+SLIDEBARHEIGHT-6,a);
#endif 
}

void draw_arrow(aptr)	
ARROW *aptr;
{
	long d[90][90];
	int x,y,i,j;
	float x1,y1,dx,dy;

	for(i=0;i<90;i++) {
		for(j=0;j<90;j++) {
			d[i][j]=aptr->back_rgb;
		}
	}
	fill_array(90,8,d,aptr->rgb);
	for(j=0;j<8;j++) {
		for(i=0;i<90;i++) d[82+j][i]=d[j][i];
	}
	for(j=0;j<8;j++) {
		for(i=j;i<90-j;i++) {
			d[i][j]=d[89-j][i];
		}
	}
	for(j=0;j<8;j++) {
		for(i=j;i<90-j;i++) {
			d[i][89-j]=d[j][i];
		}
	}
	dx=fcos(aptr->a);
	dy=fsin(aptr->a);
	x1=y1=45.0;
	for(i=0;i<30;i++) {
		x=(int)x1;
		y=(int)y1;
		d[y][x]=d[y+1][x]=d[y+1][x+1]=d[y][x+1]=aptr->rgb;
		x1+=dx;
		y1+=dy;
	}
#ifdef R_SGI
	lrectwrite(aptr->x,aptr->y,aptr->x+89,aptr->y+89,d);
#endif
}

void draw_all_arrows()
{
	int i;
	
	for(i=0;i<numarrows;i++) {
		draw_arrow(arrow[i]);
	}
}

void draw_all_slidebars()
{
	int i;

	for(i=0;i<numslidebars;i++) {
		draw_slidebar(slidebar[i]);
	}
}

void draw_all_buttons()
{
	int i;

	for(i=0;i<numbuttons;i++) {
		draw_button(button[i]);
	}
}

int find_button()	/* finds button number */
{
    int i;
    BUTTON *bptr;
    long x,y;
    int found;

#ifdef R_SGI
    if(!getbutton(LEFTMOUSE)) return(-1); /* An upward bounce */
    getorigin(&x,&y);   /* Get window origin */
    x=getvaluator(MOUSEX)-x;
    y=getvaluator(MOUSEY)-y;
    found=0;
    for(i=0;(!found)&&(i<numbuttons);i++) {
        bptr=button[i];
        if( (bptr->xstart<x) && (bptr->xstart+bptr->width>x) && (bptr->ystart<y)
&& (bptr->ystart+bptr->height>y) ) found=1;
    }
    if(found) {
        draw_invbutton(bptr);
        while(getbutton(LEFTMOUSE)) if(bptr->runfunc) bptr->runfunc();
        draw_button(bptr);
        if(bptr->actionfunc) bptr->actionfunc();
        return(i);
    }
#endif
    return(-1);
}

int find_slidebar()	/* finds slidebar number */
{
	int num,i,j;
	long winx,winy;
	long nx,oldx,defx,ny,oldy,defy;
	long a[SLIDEBARHEIGHT*MAXSLIDEBARLENGTH];
	long b[SLIDEBARHEIGHT*MAXSLIDEBARLENGTH];
	SLIDEBAR *sptr;        
	long x,y;

	num= -1;
#ifdef R_SGI
	getorigin(&winx,&winy);
	x=getvaluator(MOUSEX)-winx;
	y=getvaluator(MOUSEY)-winy;
	for(i=0;i<numslidebars;i++) {
		sptr=slidebar[i];
		if( (sptr->xstart<x) && (sptr->xstart+sptr->length>x) && (sptr->ystart<y) && (sptr->ystart+SLIDEBARHEIGHT>y) ) num=i;
	}
	if(num>(-1)) { /* it is on the large slidebar section */
		jnum=(x-10-HOFF)/220;
		sptr=slidebar[num];
		if( (sptr->xstart+sptr->pos<x) && (sptr->xstart+sptr->pos+sptr->thumb>x) && (sptr->ystart+5<y) && (sptr->ystart+SLIDEBARHEIGHT-6>y) ) { /* its on rolling part */
			defx=x-(sptr->xstart+sptr->pos);
			oldx=sptr->pos;
			fill_array(sptr->thumb,SLIDEBARHEIGHT-10,a,sptr->rgb);
			for(i=0;i<sptr->thumb;i++) {
				for(j=0;j<SLIDEBARHEIGHT-10;j++) {
					b[j*(sptr->thumb)+i]=sptr->rgb;
				}
			}
			while(getbutton(MOUSE3)) {
				nx=getvaluator(MOUSEX)-winx-defx;
				nx=nx-sptr->xstart;
				if(nx<5) nx=5;
				if(nx>sptr->length-sptr->thumb-5) nx=sptr->length-sptr->thumb-5;
				if(nx!=oldx) {
					lrectwrite(sptr->xstart+sptr->pos,sptr->ystart+5,sptr->xstart+sptr->pos+sptr->thumb-1,sptr->ystart+SLIDEBARHEIGHT-6,b);
					sptr->pos=nx;
					lrectwrite(sptr->xstart+sptr->pos,sptr->ystart+5,sptr->xstart+sptr->pos+sptr->thumb-1,sptr->ystart+SLIDEBARHEIGHT-6,a);
					oldx=nx;
					if(sptr->runfunc) {
						sptr->runfunc(nx);
					}
				}
			}
		} 
	} 
#endif
	return(num);
}

int find_arrow() 	/* Finds arrow and returns number */
{
	int num;
	long winx,winy;
	int i;
	long dx,dy,odx,ody;
	long x,y;
	float na;
	ARROW *aptr;
		 
#ifdef R_SGI
	getorigin(&winx,&winy);
	x=getvaluator(MOUSEX)-winx;
	y=getvaluator(MOUSEY)-winy;
	num= -1;
	for(i=0;i<numarrows;i++) {
		aptr=arrow[i];
		if((x>aptr->x)&&(x<aptr->x+90)&&(y>aptr->y)&&(y<aptr->y+90)) num=i;
	}
	if(num> -1) {
		jnum=(x-10-HOFF)/220;
		odx=0;
		ody=0;
		aptr=arrow[num];
		while(getbutton(MOUSE3)) {
			dx=getvaluator(MOUSEX)-winx-aptr->x-45;
			dy=getvaluator(MOUSEY)-winy-aptr->y-45;
			if((dx!=odx)||(dy!=ody)) {
				if((dx==0)&&(dy==0)) dx=1;
				na=fatan2((float)dy,(float)dx);
				aptr->a=na;
				draw_arrow(aptr);
				odx=dx;
				ody=dy;
				if(aptr->runfunc) {	
					aptr->runfunc(aptr->a);
				}
			}
		}
		if(aptr->actionfunc) {
			aptr->actionfunc();
		}
		return(num);
	}
#endif
	return(-1);
}
