/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          USER.C                                                            **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#include<math.h>
#ifdef R_SGI
#include<gl/gl.h>
#endif
#include"rob.h"

void user_function_1()
{
	double a,b;
	int i;

	b=((double)step_count)/((double)step_num);
	a=1.0-b;

	for(i=0;i<numjoints;i++) {
		joint[i]->a=a*from_joint[i]->a+b*to_joint[i]->a;
		joint[i]->d=a*from_joint[i]->d+b*to_joint[i]->d;
		joint[i]->alpha=a*from_joint[i]->alpha+b*to_joint[i]->alpha;
		joint[i]->theta=a*from_joint[i]->theta+b*to_joint[i]->theta;
	}
}

void user_function_2()
{
	if(numjoints==3) {
		joint[1]->ftheta=1.0;
		joint[2]->ftheta=0.0;
	}
}

#define RESOLUTION	10

void user_function_3()	/* path for demo3 style robot */
{
	float dx,dy,dz,a,b;
	int pnum,frac;

	if(!pathnum) {
		printf("This user program is meant for path following\n");
		exit(0);
	}

	/* does ten steps per path element */

	pnum=step_count/RESOLUTION;
	frac=step_count%RESOLUTION;
	if(pnum>=(pathnum-1)) {
		pnum=pathnum-2;
		frac=RESOLUTION-1;
	}
	b=((float)frac)/(RESOLUTION);
	a=1.0-b;

	dx= a*path_x[pnum]+b*path_x[pnum+1];
	dy= a*path_y[pnum]+b*path_y[pnum+1];
	dz= a*path_z[pnum]+b*path_z[pnum+1];

	joint[0]->d=(double)dz;
	joint[1]->a=(double)(fsqrt(dx*dx+dy*dy));
	joint[1]->theta=(double)(fatan2(dy,dx));
}

void user_function()  
{
    float dx,dy,dz,a,b,length;
    int pnum,frac;

    if(!pathnum) {
        printf("This user program is meant for path following\n");
        exit(0);
    }

    /* does ten steps per path element */

    pnum=step_count/RESOLUTION;
    frac=step_count%RESOLUTION;
    if(pnum>=(pathnum-1)) {
        pnum=pathnum-2;
        frac=RESOLUTION-1;
    }
    b=((float)frac)/(RESOLUTION);
    a=1.0-b;

    dx= a*path_x[pnum]+b*path_x[pnum+1];
    dy= a*path_y[pnum]+b*path_y[pnum+1];
    dz= a*path_z[pnum]+b*path_z[pnum+1];
	length=dx*dx+dy*dy+(dz-2.0)*(dz-2.0);

    joint[0]->theta=(double)fatan2(dy,dx);
    joint[1]->theta=(double)
		(facos(0.25*fsqrt(length))-fatan2(2.0-dz,fsqrt(dx*dx+dy*dy)));
    joint[2]->theta=(double)(facos(1.0-0.125*length)-M_PI);
}

