/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
**          SAVE.C                                                            **
****                                                                        ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#include<math.h>
#include<malloc.h>
#include<sys/types.h>
#include<string.h>
#include<stdlib.h>
#ifdef R_SGI
#include<gl.h>
#endif
#include"windowlib.h"
#include"schematic.h"
#include"rob.h"

void save_joint(ptr,fname,str)
JOINT **ptr;	/* structure to save */
char *fname;	/* filename */
char *str;		/* either "from" or "to" */
{
	int i;
	FILE *out;
	JOINT *jptr;

	out=fopen(fname,"w");
	if(!out) {
		printf("Cannot open file: %s\n",fname);
		return;
	}
	
	for(i=0;i<numjoints;i++) {
		jptr=ptr[i];
		fprintf(out,"%s %s a %lf\n",str,jptr->name,jptr->a);
		fprintf(out,"%s %s d %lf\n",str,jptr->name,jptr->d);
		fprintf(out,"%s %s alpha %lf\n",str,jptr->name,jptr->alpha);
		fprintf(out,"%s %s theta %lf\n",str,jptr->name,jptr->theta);
		fprintf(out,"\n");
	}
	fclose(out);
}

void save_from()
{
	char fn[256];
	
	sprintf(fn,"%s.from",save_name);
	save_joint(from_joint,fn,"from");
}

void save_to()
{
	char fn[256];

	sprintf(fn,"%s.to",save_name);
	save_joint(to_joint,fn,"to");
}

void save_schematic()
{
	FILE *out;
	ENTITY *eptr,*septr;
	int i,j,sj;
	char *s,*p,*sp,fn[80];
	INPUTNODE *iptr;
	OUTPUTNODE *optr;
	TRANSFORMATION *tptr;
	BIAS *bptr;

	sprintf(fn,"%s.scm",save_name);
	out=fopen(fn,"w");
	if(!out) {
		printf("Cannot open output file: %s\n",fn);
		exit(0);
	}

	/* save schematic origin */

	fprintf(out,"schematic origin %d %d\n",schematic_x,schematic_y);

	/* save schematic creates first */
	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		switch(eptr->type) {
			case ENTITY_INPUTNODE: s="inputnode"; break;
			case ENTITY_OUTPUTNODE: s="outputnode"; break;
			case ENTITY_TRANSFORMATION: s="transformation"; break;
			case ENTITY_SUMMATION: s="summation"; break;
			case ENTITY_DIFFERENCE: s="difference"; break;
			case ENTITY_BIAS: s="bias"; break;
			default:
				printf("Unknown entity type\n");
				exit(0);
		}
		fprintf(out,"schematic create %s %s %d %d\n",eptr->name,s,eptr->x,eptr->y);
	}
	fprintf(out,"\n");
	
	/* save schematic position */

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		for(j=0;j<eptr->numports;j++) {
			switch(eptr->position[j]) {
				case POS_UP: s="up"; break;
				case POS_DOWN: s="down"; break;
				case POS_LEFT: s="left"; break;
				case POS_RIGHT: s="right"; break;
				default:
					printf("Unkown position number\n");	
					exit(0);
			}
			switch(eptr->type) {
				case ENTITY_INPUTNODE:
				case ENTITY_BIAS:
					p="output";
					break;

				case ENTITY_OUTPUTNODE:
					p="input";
					break;

				case ENTITY_TRANSFORMATION:
					if(j==TRANSFORMATION_IN) p="input";
					else p="output";
					break;

				case ENTITY_SUMMATION:
					if(j==SUMMATION_INA) p="inputa";
					if(j==SUMMATION_INB) p="inputb";
					if(j==SUMMATION_OUT) p="output";
					break;

				case ENTITY_DIFFERENCE:
					if(j==DIFFERENCE_INA) p="inputa";
                    if(j==DIFFERENCE_INB) p="inputb";
                    if(j==DIFFERENCE_OUT) p="output";
					break;

				default:
					printf("Unkown entity type\n");
					exit(0);
			}
			fprintf(out,"schematic position %s %s %s\n",eptr->name,p,s);
		}
	}
	fprintf(out,"\n");

	/* save schematic connect */

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		for(j=0;j<eptr->numports;j++) {
			if(eptr->mode[j]==PORT_INPUT) {
				septr=entity[eptr->c_entity[j]];
				sj=eptr->c_port[j];
				switch(septr->type) {
					case ENTITY_INPUTNODE:
	                case ENTITY_BIAS:
   	                 	sp="output";
   	                 	break;
	
	                case ENTITY_OUTPUTNODE:
	                    sp="input";
	                    break;

	                case ENTITY_TRANSFORMATION:
	                    if(sj==TRANSFORMATION_IN) sp="input";
	                    else sp="output";
	                    break;

	                case ENTITY_SUMMATION:
	                    if(sj==SUMMATION_INA) sp="inputa";
	                    if(sj==SUMMATION_INB) sp="inputb";
	                    if(sj==SUMMATION_OUT) sp="output";
	                    break;

	                case ENTITY_DIFFERENCE:
                    	if(sj==DIFFERENCE_INA) sp="inputa";
                    	if(sj==DIFFERENCE_INB) sp="inputb";
                    	if(sj==DIFFERENCE_OUT) sp="output";
                    	break;

                	default:
                    	printf("Unkown entity type\n");
                    	exit(0);
				}
				switch(eptr->type) {
                    case ENTITY_INPUTNODE:
                    case ENTITY_BIAS:
                        p="output";
                        break;
    
                    case ENTITY_OUTPUTNODE:
                        p="input";
                        break;

                    case ENTITY_TRANSFORMATION:
                        if(j==TRANSFORMATION_IN) p="input";
                        else p="output";
                        break;

                    case ENTITY_SUMMATION:
                        if(j==SUMMATION_INA) p="inputa";
                        if(j==SUMMATION_INB) p="inputb";
                        if(j==SUMMATION_OUT) p="output";
                        break;

                    case ENTITY_DIFFERENCE:
                        if(j==DIFFERENCE_INA) p="inputa";
                        if(j==DIFFERENCE_INB) p="inputb";
                        if(j==DIFFERENCE_OUT) p="output";
                        break;

                    default:
                        printf("Unkown entity type\n");
                        exit(0);
                }
				fprintf(out,"schematic connect %s %s %s %s\n",septr->name,sp,eptr->name,p);
			}
		}
	}
	fprintf(out,"\n");

	/* save schematic bind */

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		if(eptr->type==ENTITY_INPUTNODE) {	
			iptr=(INPUTNODE *)(eptr->entity);
			switch(iptr->parameter) {
				case PAR_X: s="x"; break;
                case PAR_Y: s="y"; break;
                case PAR_Z: s="z"; break;
                case PAR_XD: s="xd"; break;
                case PAR_YD: s="yd"; break;
                case PAR_ZD: s="zd"; break;
                case PAR_DX: s="dx"; break;
                case PAR_DY: s="dy"; break;
                case PAR_DZ: s="dz"; break;
                case PAR_DXD: s="dxd"; break;
                case PAR_DYD: s="dyd"; break;
                case PAR_DZD: s="dzd"; break;
                case PAR_A: s="a"; break;
                case PAR_D: s="d"; break;
                case PAR_ALPHA: s="alpha"; break;
                case PAR_THETA: s="theta"; break;
                case PAR_AD: s="ad"; break;
                case PAR_DD: s="dd"; break;
                case PAR_ALPHAD: s="alphad"; break;
                case PAR_THETAD: s="thetad"; break;
                case PAR_ADD: s="add"; break;
                case PAR_DDD: s="ddd"; break;
                case PAR_ALPHADD: s="alphadd"; break;
                case PAR_THETADD: s="thetadd"; break;
                case PAR_FA: s="fa"; break;
                case PAR_FD: s="fd"; break;
                case PAR_FALPHA: s="falpha"; break;
                case PAR_FTHETA: s="ftheta"; break;
				default:
					printf("Unknown parameter type\n");
					exit(0);
			}
			switch(iptr->bind_mode) {
				case BIND_TO: p="to"; break;
				case BIND_FROM: p="from"; break;
				case BIND_CURRENT: p="current"; break;
				default:
					printf("Unknown bind mode\n");
					exit(0);
			}
			fprintf(out,"schematic bind %s %s %s %s\n",p,eptr->name,joint[iptr->joint]->name,s);
		}
		if(eptr->type==ENTITY_OUTPUTNODE) {
            optr=(OUTPUTNODE *)(eptr->entity);
            switch(optr->parameter) {
                case PAR_X: s="x"; break;
                case PAR_Y: s="y"; break;
                case PAR_Z: s="z"; break;
                case PAR_XD: s="xd"; break;
                case PAR_YD: s="yd"; break;
                case PAR_ZD: s="zd"; break;
                case PAR_DX: s="dx"; break;
                case PAR_DY: s="dy"; break;
                case PAR_DZ: s="dz"; break;
                case PAR_DXD: s="dxd"; break;
                case PAR_DYD: s="dyd"; break;
                case PAR_DZD: s="dzd"; break;
                case PAR_A: s="a"; break;
                case PAR_D: s="d"; break;
                case PAR_ALPHA: s="alpha"; break;
                case PAR_THETA: s="theta"; break;
                case PAR_AD: s="ad"; break;
                case PAR_DD: s="dd"; break;
                case PAR_ALPHAD: s="alphad"; break;
                case PAR_THETAD: s="thetad"; break;
                case PAR_ADD: s="add"; break;
                case PAR_DDD: s="ddd"; break;
                case PAR_ALPHADD: s="alphadd"; break;
                case PAR_THETADD: s="thetadd"; break;
                case PAR_FA: s="fa"; break;
                case PAR_FD: s="fd"; break;
                case PAR_FALPHA: s="falpha"; break;
                case PAR_FTHETA: s="ftheta"; break;
                default:
                    printf("Unknown parameter type\n");
                    exit(0);
            }
			switch(optr->bind_mode) {
                case BIND_TO: p="to"; break;
                case BIND_FROM: p="from"; break;
                case BIND_CURRENT: p="current"; break;
                default:
                    printf("Unknown bind mode\n");
                    exit(0);
            }
            fprintf(out,"schematic bind %s %s %s %s\n",p,eptr->name,joint[optr->joint
]->name,s);
        }
	}
	fprintf(out,"\n");

	/* save schematic program */

	for(i=0;i<numentities;i++) {
		eptr=entity[i];
		if(eptr->type==ENTITY_TRANSFORMATION) {
			tptr=(TRANSFORMATION *)(eptr->entity);
			fprintf(out,"schematic program %s %s/%s\n",eptr->name,tptr->top,tptr->bot);
		}
	}
	fprintf(out,"\n");

	/* save schematic bias */

	for(i=0;i<numentities;i++) {
        eptr=entity[i];
        if(eptr->type==ENTITY_BIAS) {
            bptr=(BIAS *)(eptr->entity);
            fprintf(out,"schematic bias %s %s\n",eptr->name,bptr->str);
        }
    }
    fprintf(out,"\n");

	/* save schematic noise */

	for(i=0;i<numentities;i++) {
        eptr=entity[i];
        if(eptr->type==ENTITY_INPUTNODE) {
            iptr=(INPUTNODE *)(eptr->entity);
			if(iptr->noise==NOISE_ON) {
            	fprintf(out,"schematic noise %s %lf\n",eptr->name,iptr->noise_scale);
			}
        }
    }
    fprintf(out,"\n");

	fclose(out);
}

void save_graph()	
{
    FILE *out;
    char fn[80];
	int i;
	GRAPH *gptr;
	char *h,*v;

    sprintf(fn,"%s.graph",save_name);
    out=fopen(fn,"w");
    if(!out) {
        printf("Cannot open output file: %s\n",fn);
        exit(0);
    }

	/* graph create */

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		fprintf(out,"graph create %s %d %d %d %d\n",
			gptr->name,gptr->x,gptr->y,gptr->width,gptr->height);
	}
	fprintf(out,"\n");

	/* graph mode */

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		h="auto";
		if(gptr->horizontal_mode==GMODE_FIXED) h="fixed";
		v="auto";
		if(gptr->vertical_mode==GMODE_FIXED) v="fixed";
		fprintf(out,"graph mode %s %s %s\n",gptr->name,h,v);
	}
	fprintf(out,"\n");

	/* graph horizontal */

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		if(gptr->horizontal_mode==GMODE_FIXED) {
			fprintf(out,"graph horizontal %s %lf\n",gptr->name,gptr->horizontal_scale);
		}
	}
	fprintf(out,"\n");

	/* graph vertical */

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		if(gptr->vertical_mode==GMODE_FIXED) {
			fprintf(out,"graph vertical %s %f %f\n",gptr->name,gptr->vertical_min,gptr->vertical_max);
		}
	}
	fprintf(out,"\n");

	/* graph labels */

	for(i=0;i<numgraphs;i++) {
		gptr=graph[i];
		fprintf(out,"graph labels %s %d %d\n",gptr->name,gptr->horizontal_labels,gptr->vertical_labels);
	}
	fprintf(out,"\n");

	fclose(out);
}

void save_path()
{
	char fn[256];
	FILE *out;
	int i;

    sprintf(fn,"%s.path",save_name);
	out=fopen(fn,"w");
    if(!out) {
    	printf("Cannot open file: %s\n",fn);
        return;
    }
	for(i=0;i<pathnum;i++) {
		fprintf(out,"path %f %f %f\n",path_x[i],path_y[i],path_z[i]);
	}
	fclose(out);
}
