/******************************************************************************\
********************************************************************************
********                                                                ********
******      Visual robot simulator                                        ******
****                                                                        ****
**          Author: Craig Dillon, Andrew Conway                               **
**                                                                            **
****        DRAW.C                                                          ****
******                                                                    ******
********                                                                ********
********************************************************************************
\******************************************************************************/

#include<stdio.h>
#ifdef R_SGI
#include<gl/gl.h>
#include<gl/device.h>
#endif
#include<math.h>
#include"windowlib.h"
#include"rob.h"

#ifdef R_SGI
float mat_panel[]={
    AMBIENT, .8,.2,.2,
    DIFFUSE, .5,.2,.2,
    SPECULAR, .3,.3,.3,
    SHININESS, 10,
    LMNULL};

float mat_floor[]={
    AMBIENT, .2,.2,.8,
    DIFFUSE, .2,.3,.8,
    SPECULAR, .2,.3,.8,
    SHININESS, 5,
    LMNULL};

float mat_wall[]={
    AMBIENT, .3,.3,.5,
    DIFFUSE, .3,.3,.5,
    SPECULAR, .3,.3,.5,
    SHININESS, 5,
    LMNULL};

float lm[]= {
    AMBIENT, .1,.1,.1,
    LOCALVIEWER, 1,
    LMNULL};

float lt[]={
    LCOLOR,1,1,1,
    POSITION,0,-6.0,3.0,1,
    LMNULL};
#endif

#define WALL_WIDTH	30.0
#define WALL_DOWN 0.0
#define WALL_UP 12.0

int numpictures;
PICTURE *picture[MAX_PICTURES];

void load_picture(fn)
char *fn;
{
#ifdef R_SGI
	int i,j;
	PICTURE *pptr;
	FILE *in;

	in=fopen(fn,"r");
	if(!in) {
		printf("File could not be opened: %s\n",fn);
		exit(0);
	}
	pptr=(PICTURE *)calloc(1,sizeof(PICTURE));
	fscanf(in," %d %d",&(pptr->x),&(pptr->y));
	pptr->colour=(long *)calloc(pptr->x*pptr->y,sizeof(long));
	fscanf(in," %f %f %f",&(pptr->wx),&(pptr->wy),&(pptr->wz));
	fscanf(in," %f %f %f",&(pptr->xdx),&(pptr->xdy),&(pptr->xdz));
	fscanf(in," %f %f %f",&(pptr->ydx),&(pptr->ydy),&(pptr->ydz));
	for(j=0;j<pptr->y;j++) {
		for(i=0;i<pptr->x;i++) {
			fscanf(in," %ld",&(pptr->colour[i+pptr->x*j]));
		}
	}
	picture[numpictures]=pptr;
	numpictures++;
	fclose(in);
#endif
}

void draw_path()
{
#ifdef R_SGI
	float a[3];
	int i;

	/* draw green line for actual path, black for shadow */

	cpack(0x0000ff00);
	for(i=1;i<pathnum;i++) {
		bgnline();
		a[0]=path_x[i-1];
		a[1]=path_y[i-1];
		a[2]=path_z[i-1];
		v3f(a);
		a[0]=path_x[i];
        a[1]=path_y[i];
        a[2]=path_z[i];
        v3f(a);
		endline();
	}
	cpack(0x00000000);
    a[2]=0.07;	/* puts it above grpund lines at 0.05 */
	for(i=1;i<pathnum;i++) {
        bgnline();
        a[0]=path_x[i-1];
        a[1]=path_y[i-1];
        v3f(a);
        a[0]=path_x[i];
        a[1]=path_y[i];
        v3f(a);
        endline();
    }
#endif
}

void draw_boxes()
{
#ifdef R_SGI
	int i;
	BOX *bptr;
	float v[8][3];
	float n[3];

	for(i=0;i<numboxes;i++) {	
		bptr=box[i];
		lmbind(MATERIAL,MAT_BOX+i);
		
		v[0][0]=v[1][0]=v[4][0]=v[5][0]=bptr->x-bptr->dx/2;	
		v[2][0]=v[3][0]=v[6][0]=v[7][0]=bptr->x+bptr->dx/2;	
		v[0][1]=v[3][1]=v[4][1]=v[7][1]=bptr->y-bptr->dy/2;	
		v[1][1]=v[2][1]=v[5][1]=v[6][1]=bptr->y+bptr->dy/2;	
		v[0][2]=v[1][2]=v[2][2]=v[3][2]=bptr->z;	
		v[4][2]=v[5][2]=v[6][2]=v[7][2]=bptr->z-bptr->dz;	

		n[0]=0.0;
		n[1]=0.0;
		n[2]=1.0;
		bgnpolygon();
		n3f(n);
		v3f(v[0]);
		v3f(v[1]);
		v3f(v[2]);
		v3f(v[3]);
		endpolygon();

		n[0]=0.0;
        n[1]=0.0;
        n[2]= -1.0;
        bgnpolygon();
        n3f(n);
        v3f(v[4]);
        v3f(v[5]);
        v3f(v[6]);
        v3f(v[7]);
        endpolygon();

		n[0]=0.0;
        n[1]=1.0;
        n[2]=0.0;
        bgnpolygon();
        n3f(n);
        v3f(v[0]);
        v3f(v[3]);
        v3f(v[7]);
        v3f(v[4]);
        endpolygon();

		n[0]=0.0;
        n[1]= -1.0;
        n[2]=0.0;
        bgnpolygon();
        n3f(n);
        v3f(v[1]);
        v3f(v[2]);
        v3f(v[6]);
        v3f(v[5]);
        endpolygon();

		n[0]= -1.0;
        n[1]=0.0;
        n[2]=0.0;
        bgnpolygon();
        n3f(n);
        v3f(v[3]);
        v3f(v[2]);
        v3f(v[6]);
        v3f(v[7]);
        endpolygon();

		n[0]=1.0;
        n[1]=0.0;
        n[2]=0.0;
        bgnpolygon();
        n3f(n);
        v3f(v[0]);
        v3f(v[1]);
        v3f(v[5]);
        v3f(v[4]);
        endpolygon();
	}
#endif
}

void draw_world()
{
#ifdef R_SGI
	float n[3],v[3];
	int i;
	int xx,yy;
	PICTURE *pptr;
	int index,h;
	long *cp;

	if(world_mode==WORLD_SIMPLE) {
		lmbind(MATERIAL,MAT_FLOOR);
		bgnpolygon();
		n[0]=0.0;
		n[1]=0.0;
		n[2]=1.0;
		n3f(n);	
		v[0]= -FLOOR_SIZE;
		v[1]= -FLOOR_SIZE;
		v[2]=0.0;
		v3f(v);
		v[0]= FLOOR_SIZE;
		v3f(v);
		v[1]= FLOOR_SIZE;
		v3f(v);
		v[0]= -FLOOR_SIZE;
		v3f(v);
		endpolygon();
		return;
	}
	if(world_mode==WORLD_COMPLEX) {	
	
		lmbind(MATERIAL,MAT_WALL);
		n[0]= 0.0;
		n[1]= -1.0;
		n[2]= 0.0;
		n3f(n);
		bgnpolygon();
		v[0]= -WALL_WIDTH/2;
		v[1]= WALL_WIDTH/2;
		v[2]= WALL_DOWN;
		v3f(v);
		v[2]= WALL_UP;
		v3f(v);
		v[0]= WALL_WIDTH/2;
		v3f(v);
		v[2]= WALL_DOWN;
		v3f(v);
		endpolygon();

		n[0]= 0.0;
        n[1]= 1.0;
        n[2]= 0.0;
        n3f(n);
        bgnpolygon();
        v[0]= -WALL_WIDTH/2;
        v[1]= -WALL_WIDTH/2;
        v[2]= WALL_DOWN;
        v3f(v);
        v[2]= WALL_UP;
        v3f(v);
        v[0]= WALL_WIDTH/2;
        v3f(v);
        v[2]= WALL_DOWN;
        v3f(v);
        endpolygon();

		n[0]= -1.0;
        n[1]= 0.0;
        n[2]= 0.0;
        n3f(n);
        bgnpolygon();
        v[0]= WALL_WIDTH/2;
        v[1]= -WALL_WIDTH/2;
        v[2]= WALL_DOWN;
        v3f(v);
        v[2]= WALL_UP;
        v3f(v);
        v[1]= WALL_WIDTH/2;
        v3f(v);
        v[2]= WALL_DOWN;
        v3f(v);
        endpolygon();

		n[0]= 1.0;
        n[1]= 0.0;
        n[2]= 0.0;
        n3f(n);
        bgnpolygon();
        v[0]= -WALL_WIDTH/2;
        v[1]= -WALL_WIDTH/2;
        v[2]= WALL_DOWN;
        v3f(v);
        v[2]= WALL_UP;
        v3f(v);
        v[1]= WALL_WIDTH/2;
        v3f(v);
        v[2]= WALL_DOWN;
        v3f(v);
        endpolygon();

		lmbind(MATERIAL,MAT_FLOOR);		
		n[0]= 0.0;
		n[1]= 0.0;
		n[2]= 1.0;
		n3f(n);
        bgnpolygon();
        v[0]= -WALL_WIDTH/2;
        v[1]= -WALL_WIDTH/2;
        v[2]= WALL_DOWN;
        v3f(v);
        v[0]= WALL_WIDTH/2;
        v3f(v);
        v[1]= WALL_WIDTH/2;
        v3f(v);
        v[0]= -WALL_WIDTH/2;
        v3f(v);
        endpolygon();

		cpack(0x00ffffff);
		v[2]= WALL_DOWN+0.05;
		for(i= -WALL_WIDTH/2+1; i<=(WALL_WIDTH/2-1); i+=2) {
			bgnline();
			v[0]=(float)i;
			v[1]= -WALL_WIDTH/2;
			v3f(v);
			v[1]= WALL_WIDTH/2;
			v3f(v);
			endline();
		}
		for(i= -WALL_WIDTH/2+1; i<=(WALL_WIDTH/2-1); i+=2) {
            bgnline();
            v[1]=(float)i;
            v[0]= -WALL_WIDTH/2;
            v3f(v);
            v[0]= WALL_WIDTH/2;
            v3f(v);
            endline();
        }
		lmbind(LMODEL,0);
		for(i=0;i<numpictures;i++) {
			pptr=picture[i];
			h=pptr->y;
			cp=pptr->colour;
			for(xx=0;xx<(pptr->x-1);xx++) {
				bgntmesh();	
				v[0]=pptr->wx+xx*pptr->xdx;
				v[1]=pptr->wy+xx*pptr->xdy;
				v[2]=pptr->wz+xx*pptr->xdz;
				index=xx;
				for(yy=0;yy<h;yy++) {
					cpack(cp[index]);
					v3f(v);
					v[0]+=pptr->xdx;
					v[1]+=pptr->xdy;
					v[2]+=pptr->xdz;
					cpack(cp[index+1]);
					v3f(v);
					v[0]+=pptr->ydx;
                    v[1]+=pptr->ydy;
                    v[2]+=pptr->ydz;
					v[0]-=pptr->xdx;
                    v[1]-=pptr->xdy;
                    v[2]-=pptr->xdz;
					index+=h;
				}
				endtmesh();
			}
		}
		draw_path();
		lmbind(LMODEL,1);
	}
#endif
}

void draw_segment(jptr,a,b)
float *a,*b;
JOINT *jptr;
{
	float n[3],v[3],x[3],r[3],s[3],aa[3],bb[3];
	float theta,alpha,dtheta,salpha,calpha,stheta,ctheta;
	int i,j,k;
	float mag,xdr,xds;
	int numpanels;
	float radius;
	float st[100][3];
	float sb[100][3];

	numpanels=jptr->numpanels;
	if(numpanels>99) printf("Warning: too many panels\n");
	radius=jptr->radius;

#ifdef R_SGI
	mag=0.0;
	for(i=0;i<3;i++) {	
		x[i]=b[i]-a[i];	
		mag+=((float)(x[i]*x[i]));
		r[i]=0.0;
		s[i]=0.0;
	}
	mag=1.0/fsqrt(mag);
	for(i=0;i<3;i++) {
		x[i]*=mag;
	}
	if(fabs(x[0])<fabs(x[1])) {
		j=0;
		if(fabs(x[1])<fabs(x[2])) {
			k=1;
		} else {
			k=2;
		}
	} else {
		j=1;
		if(fabs(x[0])<fabs(x[2])) {
			k=0;
		} else {
			k=2;
		}
	}
	r[j]=1.0;
	s[k]=1.0;

	xdr=x[j];
	xds=x[k];
	for(i=0;i<3;i++) {
		r[i]=r[i]-xdr*x[i];
		s[i]=s[i]-xds*x[i];
	}
	/* r and s are two orthonormal vectors, perpendicular to robot axis */

	dtheta=(2*M_PI)/((float)numpanels);
	theta=0.0;
	alpha=dtheta/2;	/* angle for normal */
	aa[0]=radius*r[0];
	aa[1]=radius*r[1];
	aa[2]=radius*r[2];
	for(i=0;i<numpanels;i++) {
		calpha=fcos(alpha);
		salpha=fsin(alpha);
		n[0]= -(calpha*r[0]+salpha*s[0]);
		n[1]= -(calpha*r[1]+salpha*s[1]);
		n[2]= -(calpha*r[2]+salpha*s[2]);
		n3f(n);
		alpha+=dtheta;

		theta+=dtheta;
		ctheta=fcos(theta)*radius;
		stheta=fsin(theta)*radius;
		bb[0]=ctheta*r[0]+stheta*s[0];
		bb[1]=ctheta*r[1]+stheta*s[1];
		bb[2]=ctheta*r[2]+stheta*s[2];

		/* everything done */

		bgnpolygon();
		v[0]=a[0]+aa[0];
		v[1]=a[1]+aa[1];
		v[2]=a[2]+aa[2];
		st[i][0]=v[0];
		st[i][1]=v[1];
		st[i][2]=v[2];
		v3f(v);
		v[0]=a[0]+bb[0];
        v[1]=a[1]+bb[1];
        v[2]=a[2]+bb[2];
        v3f(v);
		v[0]=b[0]+bb[0];
        v[1]=b[1]+bb[1];
        v[2]=b[2]+bb[2];
        v3f(v);
		v[0]=b[0]+aa[0];
        v[1]=b[1]+aa[1];
        v[2]=b[2]+aa[2];
		sb[i][0]=v[0];
		sb[i][1]=v[1];
		sb[i][2]=v[2];
        v3f(v);
		endpolygon();
		
		aa[0]=bb[0];
		aa[1]=bb[1];
		aa[2]=bb[2];
	}
	bgnpolygon();
	n[0]=x[0];
	n[1]=x[1];
	n[2]=x[2];
	n3f(n);
	for(i=0;i<numpanels;i++) {
		v3f(st[i]);
	}
	endpolygon();
	bgnpolygon();
    n[0]= -x[0];
    n[1]= -x[1];
    n[2]= -x[2];
    n3f(n);
    for(i=0;i<numpanels;i++) {
        v3f(sb[i]);
    }
    endpolygon();
#endif
}

void draw_robot()
{
	int i,j;
	float a[3],b[3];

	for(i=0;i<3;i++) b[i]=0.0;

	draw_boxes();	
	for(i=0;i<numjoints;i++) {
		for(j=0;j<3;j++) b[j]=a[j];
		a[0]=global_joint[i]->x;
		a[1]=global_joint[i]->y;
		a[2]=global_joint[i]->z;
#ifdef R_SGI
		lmbind(MATERIAL,MAT_USER+i);
#endif
		draw_segment(global_joint[i],a,b);
    }
}
