/*
 *  Window setup functions
 *  X window operations
 *
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include "X11/Xlib.h"
#include "X11/Xutil.h"
#include "X11/Xos.h"
#include <stdio.h>

Window win = 0;			/* main graphics area */
Window info_win = 0;		/* position info */
GC gc, igc;			/* window drawing GC */
GC cgc;				/* window clearing GC */
GC xgc;				/* window XORing GC */
GC *gcptr;			/* this is the one we use */
int screen;
Display *display;
Font font;

#define check_alive if (win ==  0) return(-1)

extern int win_w, win_h;	/* window width and height */

Window create_app();

/* start up a window with these dims */

init_window(width,height,argc,argv)
     int width, height;
     int argc;
     char **argv;
{ 
  if (win == 0)
    { 
  win = create_app(width,height,argc,argv);
  screen = DefaultScreen(display);

  XSetWindowBackground(display, win, WhitePixel(display,screen)) ;
  XSetWindowBorder(display, win, BlackPixel(display,screen)) ;

  gc  = XCreateGC(display,win,0,NULL);
  XSetBackground(display, gc, WhitePixel(display,screen));
  XSetForeground(display, gc, BlackPixel(display,screen));
  XSetLineAttributes(display, gc, 0, LineSolid, CapButt, JoinMiter);
  XSetGraphicsExposures(display, gc, False);
                        
  font = XLoadFont(display,"-misc-fixed-bold-r-normal--13-100-100-100-c-70-iso8859-1");
  if ( font == 0  )
    { printf("can't find font\n"); exit(-1); }
  XSetFont(display, gc, font);

  cgc  = XCreateGC(display,win,0,NULL);
  XSetBackground(display, cgc, BlackPixel(display,screen));
  XSetForeground(display, cgc, WhitePixel(display,screen));
  XSetGraphicsExposures(display, cgc, False);

  xgc  = XCreateGC(display,win,0,NULL);
  XSetBackground(display, xgc, WhitePixel(display,screen));
  XSetForeground(display, xgc, BlackPixel(display,screen));
  XSetFunction(display, xgc, GXxor);
  XSetGraphicsExposures(display, xgc, False);

  igc  = XCreateGC(display,info_win,0,NULL);
  XSetGraphicsExposures(display, igc, False);
  XSetBackground(display, igc, WhitePixel(display,screen));
  XSetForeground(display, igc, BlackPixel(display,screen));
  XSetFont(display, igc, font);

  gcptr = &gc;
  return(1);
    }
}

/* Invert window from black to white */

change_window_color()		
{
  static int old_color = 0;	/* white = 1 for white background, 0 for black */
     if (win) {
       old_color = 1 - old_color;
       if (old_color) {
	 XSetWindowBackground(display, win, WhitePixel(display,screen)) ;
	 XSetWindowBorder(display, win, BlackPixel(display,screen)) ;

	 XSetBackground(display, gc, WhitePixel(display,screen));
	 XSetForeground(display, gc, BlackPixel(display,screen));

	 XSetBackground(display, cgc, BlackPixel(display,screen));
	 XSetForeground(display, cgc, WhitePixel(display,screen));

       } else {
	 XSetWindowBackground(display, win, BlackPixel(display,screen)) ;
	 XSetWindowBorder(display, win, WhitePixel(display,screen)) ;

	 XSetBackground(display, gc, BlackPixel(display,screen));
	 XSetForeground(display, gc, WhitePixel(display,screen));

	 XSetBackground(display, cgc, WhitePixel(display,screen));
	 XSetForeground(display, cgc, BlackPixel(display,screen));
       }
     }
   }


/* show window */

show_window()
{
  check_alive;
  XRaiseWindow(display, win);
  XSync(display,1);
}

/* flush the buffers */

display_buffer()
{
  check_alive;
  XFlush(display);
}


kill_window()
{
  if (win)
    { XCloseDisplay(display); }	/* close all services for this client */
  win = 0;
}


/* switching vector buffer */

set_graphics(w)		/* w = 0 is clear, 1 is set, 2 is xor */
{
  switch (w) {
  case 0: gcptr = &cgc; break;
  case 1: gcptr = &gc; break;
  case 2: gcptr = &xgc;}
}
    

/* clear the graphics window */

clear_window()		/* clear it */
{
  check_alive;
  XFillRectangle(display, win, cgc, 0,  0, win_w, win_h); 
  XFlush(display);
}

/* draw a line segment */

draw_line(x1,y1,x2,y2)
{
  XDrawLine(display,win,*gcptr,x1,y1,x2,y2);
}

/* draw a line-dx/dy segment */

draw_dline(x,y,dx,dy)
{
  XDrawLine(display,win,*gcptr,x,y,x+dx,y+dy);
}


draw_oval(x,y,w,h)		/* draw an oval */
{
  XDrawArc(display,win,*gcptr,x,y,w,h,0,(360*64));
}

/* draw a line segment */

draw_point(x,y)
{
  XDrawPoint(display,win,*gcptr,x,y);
}



/* draw  numeric info */

char outstr[30];

draw_num(n,d,x,y)		/* n is value, d is format descriptor */
     char *d;
{
  sprintf(outstr,d,n);
  XDrawImageString(display,info_win,igc,x,y,outstr,strlen(outstr));
}
