/*  MANUAL_BUG.P  */


section $-bug => think, manual_bug;


/*
This is the ``manual bug''. It has no intelligence of its own, but
simply reads and performs actions as you type them.

The prompts for actions are self-explanatory. All replies are one letter
long, and you must not hit RETURN after them.
*/


vars think;/*forward*/


define global manual_bug();
    repeat
        think();
    endrepeat;
enddefine;


define global think();
    lvars keypress;

    bug_message('F-forward B-back L-left R-right G-grab D-drop U-use W-wait O-other Q-quit');

    getkey() -> keypress;
    switchon keypress
    case = `f` then exec([forward])
    case = `b` then exec([back])
    case = `l` then exec([left])
    case = `r` then exec([right])
    case = `g` then exec([grab])
    case = `d` then exec([drop])
    case = `w` then exec([wait])
    case = `u` then exec([use])
    case = `q` then exit_eden()
    case = `o` then exec(other())
    else
        think()
    endswitchon
enddefine;


define other();
    lvars action, mess='', keypress;
    for action in $-worlds$-actions do
        mess >< cons_with consstring {% action(1).lowertoupper %}
             >< '-' >< action >< ' ' -> mess;
    endfor;
    bug_message( mess );
    getkey() -> keypress;

    for action in $-worlds$-actions do
        if action(1)=keypress then
            return( [%action%] )
        endif;
    endfor;
    think();
enddefine;


define getkey();
    if bug_using_ved() then
        rawcharin().uppertolower
    else
        charin().uppertolower
    endif;
enddefine;


/*
define bugdead();
    "rerun"
enddefine;
*/


endsection;
