section $-objects;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __digesting, __smelly, __smell_time, __eat_time;


define my_start1();
    false -> __smelly;
    false -> __digesting;
    0 -> __smell_time;
    0 -> __eat_time;
enddefine;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    if __smelly and __smell_time < $-eden$-time-5 then
        kill( 'You smell of food and have been eaten by a predator!' );
    endif;

    if __digesting and __eat_time < $-eden$-time-15 then
        kill( 'You waited too long before defecating and have burst!' );
    endif;

    for i from 0 to bw_world_width($-eden$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define my_line1() -> items -> format;
    lvars format, items;
    'Action: ~10A  Facing: ~8A Position: ~8A Digesting: ~8A' -> format;
    [% trunc($-eden$-last_action,10),
       direction(),
       '('><bug_xW()><','><bug_yW()><')',
       __digesting
    %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A Here: ~8A   Time: ~8A     Smelly: ~8A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __smelly
    %] -> items;
enddefine;


/*
Food
----
*/


vars old_food;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time ->> __smell_time -> __eat_time;
        true -> __digesting;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Cleaning
--------
*/


define water(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        false -> __smelly;
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water, `w` );


/*
Excretion
*/


vars faeces_states = newproperty( [], 5, undef, true );


define faeces(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[new] then
        $-eden$-time -> faeces_states(id);
    case =[update] then
        if faeces_states(id) < $-eden$-time-10 then
            destroy(id)
        endif
    else
        portable(message,id,x,y);
    endswitchon;
enddefine;
define_object( "faeces", faeces, `f` );


vars old_nothing;
nothing -> old_nothing;
define nothing(message,id,x,y);
    lvars message, id, x, y;
    lvars newid;
    switchon message
    case =[defecate] then
        new(`f`) -> newid;
        old_nothing(message,id,x,y);
        place( newid, [%x,y%] );
        false -> __digesting;
    else
        old_nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


/*
New actions
-----------
*/


define_action( "defecate" );


endsection;
