/*  gbug6.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


1 prio
heard( S )
=>
exec( S ).


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
