;;; -*- Package: Toolset; Syntax: Common-Lisp; Mode: Lisp; Base: 10 -*-

(in-package 'toolset)

(DEFUN PARSE-TRANSFORMS (TRANSFORM-SPEC-VECTOR conf-set 
					       FEATURE-RESULT-TYPE-VECTOR)
  (declare (ignore conf-set))
  ;; ^ not used now, but may need it
   (LET
    ((TRANSFORM-VECTOR (MAKE-ARRAY (LIST (LENGTH TRANSFORM-SPEC-VECTOR)
                                         )
                              :INITIAL-ELEMENT NIL))
     (RESULT-CONF-SET-VECTOR (MAKE-ARRAY (LIST (LENGTH 
                                                  TRANSFORM-SPEC-VECTOR
                                                      ))
                                    :INITIAL-ELEMENT NIL))
     (RESULT-FORM NIL)
     (CURRENT-CONF-SET NIL)
     TRANS)
    (DOTIMES
     (J (LENGTH TRANSFORM-SPEC-VECTOR))
     (IF
      (AND (= (LENGTH (AREF TRANSFORM-SPEC-VECTOR J))
              1)
           (EQ (CAR (AREF TRANSFORM-SPEC-VECTOR J))
               'NO-OP))
      (PROGN (SETF RESULT-FORM NIL)
             (SETF (AREF RESULT-CONF-SET-VECTOR J)
                   (AREF FEATURE-RESULT-TYPE-VECTOR J)))
      (PROGN
       (IF (NOT (LISTP (CAR (AREF TRANSFORM-SPEC-VECTOR J))))
           (SETF TRANS (LIST (AREF TRANSFORM-SPEC-VECTOR J)))
           (SETF TRANS (AREF TRANSFORM-SPEC-VECTOR J)))
       (SETF CURRENT-CONF-SET (AREF FEATURE-RESULT-TYPE-VECTOR J))
       (DOLIST
	;; go through the transform for feature j, which may be
	;; a transform, no-op, or a list of transforms
        (CURRENT-TRANS TRANS)
        (CASE
         (CAR CURRENT-TRANS)
         (NO-OP NIL)
         (THRESHOLD-AT
          (IF (NOT (NUMBERP (SECOND CURRENT-TRANS)))
              (ERROR 
     "ERROR: ~S argument to a THRESHOLD-AT transform must be a number." 
                     CURRENT-TRANS))
          (SETF RESULT-FORM
                (CONS `(IF (> RESULT ,(SECOND CURRENT-TRANS))
                           (SETF RESULT 'T)
                           (SETF RESULT 'F)) RESULT-FORM))
          (SETF CURRENT-CONF-SET 'USUAL-2-VAL))
         (INVERT (SETF RESULT-FORM
                       (CONS 
			`(setf result
			       (apply
				',(INVERT-FORM 
				   (RETURN-GENERIC-INSTANCE
				    CURRENT-CONF-SET))
				(list result)))
                             RESULT-FORM)))
         (CONVERT-TO 
	  (SETF RESULT-FORM
		(CONS 
		 `(setf result
			(apply
			 ',(CONVERT-FORM 
			    (RETURN-GENERIC-INSTANCE currenT-CONF-SET)
			    (return-generic-instance
			     (SECOND CURRENT-TRANS)))
			 (list result)))
		 RESULT-FORM))
	  (SETF CURRENT-CONF-SET (SECOND CURRENT-TRANS)))
         (OTHERWISE (ERROR 
                   "ERROR: ~S is not a recognized transform specifier." 
                           CURRENT-TRANS))))
       
       ;; record the ending confidence set, to be used in
       ;; parsing the tests of this feature

       (SETF (AREF RESULT-CONF-SET-VECTOR J)
             CURRENT-CONF-SET)
       
       ;; get rid of NIL's

       (SETF RESULT-FORM (REMOVE NIL RESULT-FORM))
       
       ;; if empty transform (ex. convert from usual-3-val to
       ;; usual-3-val), leave it NIL, else

       (IF
        (NOT (NULL RESULT-FORM))
        (PROGN
       
       ;; stick on the RETURN form

         (SETF RESULT-FORM (CONS '(RETURN RESULT) RESULT-FORM))
       
       ;; get it into the right order

         (SETF RESULT-FORM (NREVERSE RESULT-FORM))
         (SETF
          RESULT-FORM
          (LIST
           'LAMBDA
           '(INPUT)
           `,(LIST 'BLOCK NIL (CONS 'LET (CONS '((RESULT INPUT)) 
                                               RESULT-FORM)))))))))
     (SETF (AREF TRANSFORM-VECTOR J)
           RESULT-FORM)
       
       ;; get ready for next time round

     (SETF RESULT-FORM NIL))
    (RETURN-FROM PARSE-TRANSFORMS (VALUES TRANSFORM-VECTOR 
                                         RESULT-CONF-SET-VECTOR))))

