;;; -*- package: toolset; syntax: common-lisp; mode: lisp; base: 10 -*-

(in-package 'toolset)

(defmethod compile-dragon-type (idb-name (stub-idb-instance stub-idb)
                              gt-code-body) 
  "Compiles a stub idb specification."
   

;;; 
;;; first, set up the mandatory and forbidden slot lists and stuff the
;;; slots

;;; then stuff the action slot with the ask function

;;; 

  (let ((mandatories '(author))
	(forbidden 
	 '(judge-lambda match-action match-confidence 
			no-match-action no-match-confidence pattern 
			patterns success-threshold transforms 
			features)))
       (stuff-ra-slots stub-idb-instance gt-code-body mandatories 
		       forbidden)
       (if (slot-empty-p stub-idb-instance 'display-name)
	   (setf (slot-value stub-idb-instance 'display-name)
		 (symbol-name (slot-value stub-idb-instance 'unique-name))))

       (format *trace-output* "Building controller.~%")
       (setf (slot-value stub-idb-instance 'parsed-controller) nil
	     (slot-value stub-idb-instance 'parsed-tracing-controller) nil)
       (if (not (slot-empty-p stub-idb-instance 'control-additions))
	   (parse-controller-slot stub-idb-instance
				  'stub-idb))
	 ;; make sure things come out in the right order -- the
	 ;; user-specified lambdas must come first in the assoc list,
	 ;; so they can shadow any system-define verbs they redefine

       (setf 
	(slot-value stub-idb-instance 'parsed-controller)
	(append
	   ;; make sure things come out in the right order -- the
	   ;; user-specified lambdas must come first in the assoc list,
	   ;; so they can shadow any system-define verbs they redefine
	   (slot-value stub-idb-instance 'parsed-controller)
	   (controllers stub-idb-instance))

	(slot-value stub-idb-instance 'parsed-tracing-controller)
	  (append (slot-value stub-idb-instance 'parsed-tracing-controller)
		  (controllers stub-idb-instance)))

       (format *trace-output* "Compiling controller.~%")
       (if *compile-controller*
	   (setf (slot-value stub-idb-instance 'actions)
		 (compile-controller
		  (slot-value stub-idb-instance 'parsed-controller)))
	   (setf (slot-value stub-idb-instance 'actions)
		 (slot-value stub-idb-instance 'parsed-controller)))
       (format *trace-output* "Finished compiling stub-idb ~s.~%"
	       idb-name)))



(defmacro define-idb (idb-name idb-type &body gt-code) 

;;; ---------------------------------------------------
 

;;; syntax for a define-idb macro call is (define-idb unique-name type
;;; [options]*

;;; the last thing called is compile-idb which defines the action
;;; verbs and stuffs the slots.

;;; ---------------------------------------------------

 (if (null gt-code)
     (error "error in the idb definition of ~s. nothing was specified." 
            idb-name))
       
       ;; ------------------
       
       ;; begin macro 
       
       ;; ------------------

 `(let (temp)
       (format *trace-output* "~%~%~%~%~%")
       (if (and (boundp ',idb-name)
                (typep ,idb-name 'dragon))
           (progn 
                  (format *trace-output* 
                         "Destroying old version of ~s.~%"
                         ',idb-name)
		  ;;  (toolbed::destroy ,idb-name)
                  (setf ,idb-name (pcl::*make-instance ',idb-type)))
           (defparameter ,idb-name (pcl::*make-instance
                                             ',idb-type)))
       (format *trace-output* "Making new instance of ~s named ~s.~%"
              ',idb-type
              ',idb-name)
       (setf (slot-value ,idb-name 'unique-name)
             ',idb-name)
       (format *trace-output* "Compiling ~s. ~%" ',idb-name)
       (compile-dragon-type ',idb-name ,idb-name ',gt-code)))


(defun cases-saved (idb)
  (if (not (typep idb 'stub-idb))
      (error "~s is not of type stub-idb." idb))
  (return-from cases-saved 
	       (mapcar #'car (slot-value idb 'saved-case-cache))))

(defun save-case (idb &optional &key (delete nil))
  (declare (special *current-case*))
  (if (not (typep idb 'stub-idb))
      (error "~s is not of type stub-idb." idb))
  (if (>= (length (slot-value idb 'saved-case-cache))
	  (slot-value idb 'saved-case-limit))
      (if delete
	  (progn
	    (format *trace-output*
		"Case ~s is being deleted to make space for the new case.~%"
		(caar (last (slot-value idb 'saved-case-cache))))
	    (setf (slot-value idb 'saved-case-cache)
		  (butlast (slot-value idb 'saved-case-cache))))
	(error "Saving case ~s would saved exceed the saved-case-limit of ~s ~
	cases of idb ~s.~%~%
		to save this case, etiher:
		1) unsave a case from the idb with forget-case, then
			use save-case again to save this case
		2) use save-case with the keyword  argument :delete t
			to delete the oldest case from the idb's cache
			and save this case
		3) use set-saved-case-limit to enlarge the idb's limit~%~%"
	     *current-case* (slot-value idb 'saved-case-limit)
	     (slot-value idb 'unique-name))))
  (if (member *current-case* 
	      (mapcar #'car (slot-value idb 'saved-case-cache))
		      :test #'equal)
      (setf (slot-value idb 'saved-case-cache)
	    (remove (assoc *current-case* 
			   (slot-value idb 'saved-case-cache)
			   :test #'equal)
		    (slot-value idb 'saved-case-cache))))
  (setf (slot-value idb 'saved-case-cache)
	(acons *current-case*
	       (slot-value idb 'answer-cache)
	       (slot-value idb 'saved-case-cache))))


(defmacro saved-case-limit (idb)
  `(slot-value ,idb 'saved-case-limit))

(defmacro set-saved-case-limit (idb val)
  `(setf (slot-value ,idb 'saved-case-limit) ,val))

(defun forget-case (case idb)
  (if (not (typep idb 'stub-idb))
      (error "~s is not of type stub-idb." idb))
  (if (not (member case (cases-saved idb) :test #'equal))
      (format "~s has not been saved by idb ~s."
	      case idb)
      (setf (slot-value idb 'saved-case-cache)
	    (remove (assoc case (slot-value idb 'saved-case-cache)
			   :test #'equal)
		    (slot-value idb 'saved-case-cache)))))

(defmacro case-saved? (case idb)
  `(member ,case 
	   (mapcar #'car (slot-value ,idb 'saved-case-cache))
	   :test #'equal))
