;;; -*- Mode: LISP -*-

(in-package 'user)

;;;; Basic rules for JSAINT.
;;;; Version 1, Last edited 5/3/91

;;; Copyright (c) 1991, Kenneth D. Forbus, Northwestern
;;; University, and Johan de Kleer, Xerox Corporation.
;;; All Rights reserved.

;;; Expand pointers
(rule ((:in (AND-SUBGOALS ?parent ?children) :var ?def))
      (dolist (child ?children)
	(rlet ((?child (:eval child)))
	      (rassert! (PARENT-OF ?child ?parent :AND)
			(:def-of-AND ?def))
	      (rule ((:in (failed ?child) :var ?delinquent))
		    (rassert! (failed ?parent)
			      (:AND-failure ?def ?delinquent)))))
      (assert! `(solved ,?parent)
		`(:AND-success ,?def
		  ,@ (mapcar #'(lambda (child)
				 `(SOLVED ,child))
			     ?children))))

(rule ((:in (OR-SUBGOALS ?parent ?children) :var ?def
	    :test ?children))
      (dolist (child ?children)
	(rlet ((?child (:eval child)))
	      (rassert! (PARENT-OF ?child ?parent :OR)
			(:def-of-OR ?def))
	      (rule ((:in (SOLVED ?child) :var ?winner))
		    (rassert! (SOLVED ?parent)
			      (:OR-success ?winner ?def)))))
      (assert! `(FAILED ,?parent)
	       `(:OR-failure ,?def
			     ,@ (mapcar #'(lambda (child) `(FAILED ,child))
					?children))))

(rule ((:in (PARENT-OF ?child ?parent ?type) :var ?lineage))
      (rassert! (RELEVANT ?child)
		(:Still-working-on (OPEN ?parent) ?lineage)))

(rule ((:in (SOLUTION-OF ?problem ?answer) :var ?found))
      (rassert! (SOLVED ?problem) (:found-answer ?found)))

(rule ((:in (OR-SUBGOALS (Integrate ?expr) NIL) :var ?no-ideas))
      (rassert! (FAILED (Integrate ?expr)) (:no-methods ?no-ideas)))

(rule ((:in (SOLVED ?problem))) ;; Can only happen once
      (retract! `(OPEN ,?problem) ':EXPAND-AGENDA-ITEM t))

(rule ((:in (FAILED ?problem))) 
      (retract! `(OPEN ,?problem) ':EXPAND-AGENDA-ITEM t))
