;;;;
;;;; Zeno domain for transportation problems
;;;;

(in-package "ZENO")

(defun truck-world-domain ()
  (reset-domain)
  (add-domain-function 'vehicle-capacity)
  (add-domain-function 'vehicle-speed)
  (add-domain-function 'object-size)
  (add-domain-function 'distance-between)

 (define (operator drive)
  :parameters (?veh ?from ?to)
  :at-time (?s ?e)
  :precondition (:and (:static (vehicle ?veh))
		      (:static (place ?from))
		      (:static (place ?to))
		      (:eq (:value-at ?s (location ?veh)) ?from)
                      (= (- ?e ?s)
                         (* (distance-between ?from ?to)
			    (vehicle-speed ?veh))))
  :effects
   ((:cause
     (:eq (:value-at ?e (location ?veh)) ?to))
    ))


  (define (operator load)
     :at-time (?s ?e)
     :parameters (?obj ?veh)
     :precondition (:and (:static (object ?obj))
			 (:static (vehicle ?veh))
			 (:eq (:value-at ?s (location ?obj))
			      (:value-at ?s (location ?veh)))
			 (<= (object-size ?obj)
			     (:value-at ?s (vehicle-current-capacity ?veh))))
     :effects
     ((:cause
       (= (:value-at ?e (vehicle-current-capacity ?veh))
	  (- (:value-at ?s (vehicle-current-capacity ?veh))
	     (object-size ?obj))))
      (:cause
       (:eq (:value-at ?e (location ?obj)) ?veh))))


    (define (operator unload)
     :at-time (?s ?e)
     :parameters (?obj ?veh)
     :precondition (:and (:static (object ?obj))
			 (:static (vehicle ?veh))
			 (:eq (:value-at ?s (location ?obj)) ?veh))
     :effects
     ((:cause
       (= (:value-at ?e (vehicle-current-capacity ?veh))
	  (+ (:value-at ?s (vehicle-current-capacity ?veh))
	     (object-size ?obj))))
      (:cause
       (:eq (:value-at ?e (location ?obj)) (:value-at ?s (location ?veh))))))
    )


(setf *tw-problem*
  (make-problem
   :name 'truckworld-1
   :domain 'truck-world-domain
   :inits '((:cause (:and (:static (object cargo-1))
			  (:static (object cargo-2))
	    (:static (vehicle truck-1))
	    (:static (place parking-lot))
	    (:static (place warehouse-1))
	    (:static (place customer-1))

	    (= 10 (vehicle-capacity truck-1))
	    (= 2 (vehicle-speed truck-1))
	    (= 5 (object-size cargo-1))
	    (= 7 (object-size cargo-2))
	    (= 8 (distance-between parking-lot warehouse-1))
	    (= 8 (distance-between warehouse-1 parking-lot))
	    (= 12 (distance-between warehouse-1 customer-1))
	    (= 12 (distance-between customer-1 warehouse-1))
		
	    (= (vehicle-capacity truck-1)
	       (:value-at 0 (vehicle-current-capacity truck-1)))
	    (:eq parking-lot (:value-at 0 (location truck-1)))
	    (:eq warehouse-1 (:value-at 0 (location cargo-1)))
	    (:eq warehouse-1 (:value-at 0 (location cargo-2)))
	    )))
   :goal '(:and
	   (:eq customer-1 (:value-at :goal (location cargo-1)))
	   (:eq customer-1 (:value-at :goal (location cargo-2)))
;(:eq truck-1 (:value-at :goal (location cargo-1)))
	   )))
		
#||

Start......................................  ||
  Distance-between(parking-lot,warehouse-1)  |-------------------|
  Vehicle-speed(truck-1)...................  |-------------------|
  Location(truck-1)........................  |---|
  Place(warehouse-1).......................  |-------------------|
  Place(parking-lot).......................  |-------------------|
  Object-size(cargo-1).....................  |-------------------|
  Vehicle-current-capacity(truck-1)........  |-----------|
  Location(cargo-1)........................  |-----------|
  Vehicle(truck-1).........................  |-------------------|
  Object(cargo-1)..........................  |-------------------|
Drive(truck-1,parking-lot,warehouse-1).....      |---|
  Location(truck-1)........................          |---|
Load(cargo-1,truck-1)......................              |---|
  Location(cargo-1)........................                  |---|
Goal.......................................                      ||
                                             0  S2  E2  S1  E1 Goal
Complete!
Succeeded in 2.017 seconds.
Unify:    2280 clauses unified.
Plans:    62 visited of 136 created.
          14 inconsistent, 0 invalid, 5 impossible.
Posted:   542 constraints, generating 347 codesgs,
          129 eqns, 26 lineq, 19 nonlin.
Solved:   598 ero's (165 actually needed; 18 from simplex)
          14 Simplex pivots, 129 Gaussian pivots, 1 wakeups.

Gauss->Simplex: 14
Gauss->Nonlin:  0
Simplex->Gauss: 20
#plan<S=2; O=0; U=0>
ZENO(50): 
||#
