;;;; Lisp Preferences

(in-package "USER")

;;; Compiler and CLOS preferences

(SETQ *METHODS-NAMED* NIL)
(SETQ *SAVE-DOC-STRINGS* T)
(SETQ *SAVE-LAMBDA-LISTS* T)
(SETQ *FASL-SAVE-DOC-STRINGS* NIL)
(SETQ *FASL-SAVE-LAMBDA-LISTS* NIL)
(SETQ *COMPILER-WARNINGS* 'IGNORE)
(SETQ ACL::*SAFETY-LEVEL* 2)
(SETQ ACL::*SPACE-LEVEL* 0)
(SETQ ACL::*SPEED-LEVEL* 3)

;;; Reader preferences

(SETQ *CASE-SENSITIVE-INTERN* T)
(SETQ *READ-TOLERANT* NIL)
(SETQ *READ-SOURCE* NIL)
(SETQ *READ-CASE* :UPCASE)
(SETQ *READ-BASE* 10)

;;; Printer preferences

(SETQ *PRINT-ESCAPE* T)
(SETQ *PRINT-PRETTY* NIL)
(SETQ *PRINT-CIRCLE* NIL)
(SETQ *PRINT-GENSYM* T)
(SETQ *PRINT-ARRAY* T)
(SETQ PRINTER:*PRINT-LINE-WRAPS* NIL)
(SETQ PRINTER:*PRINT-STRUCTURE* T)
(SETQ *PRINT-RADIX* NIL)
(SETQ *PRINT-BASE* 10)
(SETQ *PRINT-CASE* :UPCASE)
(SETQ *TOP-PRINT-LEVEL* 4)
(SETQ *PRINT-LEVEL* NIL)
(SETQ *TRACE-PRINT-LEVEL* 4)
(SETQ *TOP-PRINT-LENGTH* 8)
(SETQ *PRINT-LENGTH* NIL)
(SETQ *TRACE-PRINT-LENGTH* 8)

;;; Inspector preferences

(SETQ INSP:*INSPECT-BIT-VECTOR-AS-SEQUENCE* T)
(SETQ INSP:*INSPECT-STRING-AS-SEQUENCE* T)
(SETQ INSP:*INSPECT-STRUCTURE-AS-SEQUENCE* NIL)
(SETQ INSP:*SEQUENCE-STRUCTURE-SLOTS-SETTABLE* NIL)
(SETQ INSP:*INSPECT-BITMAP-AS-ARRAY* NIL)
(SETQ INSP:*INSPECT-LENGTH* 300)
(SETQ INSP:*INSPECT-LIST* :SEQUENCE)
(SETQ INSP::*INSPECTOR-FONT* #.(MAKE-FONT NIL NIL 10 NIL))

;;; Editor preferences

(TEXT-EDIT:SET-TEXT-EDIT-MODE :HOST)
(SETQ TE:*EDITOR-FONT* #.(MAKE-FONT NIL :FIXEDSYS 17 NIL))
(SETQ TE::*PRETTY-PRINTER* :REINDENT)
(SETQ TE::*FLASH-HOW-OFTEN* T)
(SETQ TE:*ANALYSE-DEFINITIONS-ON-OPENING* NIL)
(SETQ TOP::*CROSS-REFERENCE-FORMS* T)
(SETQ TOP::*WARN-ON-REDEFINITION* T)
(SETQ PRINTER:*COMMENT-INDENT* 55)
(SETQ PRINTER:*JUSTIFY-COMMENTS* T)

;;; Toploop preferences

(SETQ TOP:*TOP-QUERY-EXIT* T)
(SETQ *LOAD-VERBOSE* T)
(SETQ *BREAK-ON-WARNINGS* NIL)
(SETQ TOP:*TOP-HISTORY-LIMIT* 25)
(SETQ *LISP-CLIPBOARD-LIMIT* 20)
(SETQ TOP:*TOP-PROMPT* "~%~*~V@{>~} ")
(SETQ TOP::*TOP-FONT* #.(MAKE-FONT NIL :FIXEDSYS 15 NIL))

;;; site preferences

(SETQ *FORMAT-DATE-STYLE* :US)
(SETQ *TIME-ZONE* 0)
(SETQ ACL::*USER-NAME* "")
(SETQ ACL::*MACHINE-INSTANCE* "")
(SETQ ACL::*SHORT-SITE-NAME* "")
(SETQ ACL::*LONG-SITE-NAME* "")

;;;; End of file
