;;; -*- Mode: Lisp; Package:user; Syntax:common-lisp; Base:10 -*-
;;; Copyright 1988, 1989, 1990 David Throop at the University of Texas at Austin
;;; Lispview extensions added by BKay 27Jun92

;;; The package definition is device independent.  The DefSystem's are
;;; machine depedent but conditionalized with readmacros.  This file is
;;; the system file for both Symbolics and TI Explorers

;;; Special note for use with lispview:
;;;   In addition to the other platforms supported, this file also contains
;;;   the system definition for the lispview version of the system.
;;;   Lispview provides an alternate set of display primitives
;;;   for machines that run X.  The same defsystem works for X and lispview
;;;   since it has been conditionalized with reader macros to include lispview
;;;   extension files only when necessary.  It is assumed that lispview and clos
;;;   have been loaded before this file is run.


;;; Define the POS package, using all of the Common Lisp functions.
;;; Use scl:send & scl:self in device-dependent code.



#+(or symbolics ti)
  (unless (pkg-find-package 'pos :find)
          (Defpackage pos 
                     (:use cl #+:symbolics scl)
                     (:import send self defmethod)))

(in-package 'pos)




;;; Define a special variable which keps track of the options which
;;; can be selected when loading QSIM.  This variable defines options
;;; for both QSIM and POS and it is defined in both system files.
;;;
;;; This variable is also defined in
;;;
;;;       cl-nq-system.lisp
;;;
;;; IF CHANGES ARE MADE, PLEASE UPDATE THIS FILE TOO !!!!!!!!

(defvar user::*qsim-pos-options* '((pos-display-choice nil)))

;;; Functions and macros which can be used to access the options list.
;;; These functions should also be defined in the
;;;
;;;        cl-nq-system.lisp
;;;
;;; IF YOU MAKE CHANGES PLEASE UPDATE THIS FILE TOO!!!!

(unless (fboundp 'user::get-qsim-pos-option)
  (defmacro user::get-qsim-pos-option (option)
    `(cadr (assoc ,option user::*qsim-pos-options*))))

(unless (fboundp 'user::set-qsim-pos-option)
  (defmacro user::set-qsim-pos-option (option setting)
    `(cond ((assoc ,option user::*qsim-pos-options*)
	    (setf (cadr (assoc ,option user::*qsim-pos-options*)) ,setting))
            (t (pushnew (list ,option ,setting) user::*qsim-pos-options*)
	       (cadr (assoc ,option user::*qsim-pos-options*))))))



;;; Determine what version of pos to load and add it to the features list.
;;; If POS-DISPLAY-CHOICE on the user::*qsim-pos-options* special variable is set
;;; then the user is not prompted.  Other wise, the user is prompted
;;; for the display method.
;;; If we are using the xbatch version then the feature is :x-windows.
;;; If we are using the lispview version then the feature is :pos-lispview
;;; (the :lispview keyword is already taken).
;;; Note that this question is ignored if either :X-windows or :pos-lispview
;;; is already on the feature list.
;;;
#+(and (not :ccl) (not lispm) (not (or :x-windows :pos-lispview)))
  (unless (user::get-qsim-pos-option 'user::pos-display-choice)
    (progn (clear-input t)
	   (format t "~%~%")
	   (cond
	     ((and (member :lucid *features*)
		   (mk::y-or-n-p-wait #\n 20 "Do you want to use the LispView display routines? [ny] "))
	      (user::set-qsim-pos-option 'user::pos-display-choice :pos-lispview))
	     (t (user::set-qsim-pos-option 'user::pos-display-choice :x-windows)))))

(unless (equal (user::get-qsim-pos-option 'user::pos-display-choice) :none)
  (pushnew (user::get-qsim-pos-option 'user::pos-display-choice)
	   *features*))

    


;;; Ensure that clos and lispview are loaded before continuing.
;;;
#+:pos-lispview
  (let ((*clos-bin* "/lusr/lang/lisp/clos.sbin")
	(*lispview-bin* "/lusr/lang/lisp/lispview.sbin")
	(user-pwd (user::pwd)))
    (unless (member :clos *features*) (load *clos-bin*))
    (unless (member :lispview *features*) (load *lispview-bin*))

    ;; Loading these packages clobbers the current working directory,
    ;; so set it back when we are done.
    (user::cd user-pwd)
    )




;;; These are the functions and variables that other (client) code that
;;; uses the POS system will need to use.  We need to do two things.
;;; First we must EXPORT them.  This makes them accessable without using
;;; the the "::" syntax, from other packages.  Then, the package of a
;;; client system should IMPORT them, making them accessable without
;;; using the POS: prefix.


(defparameter *drawing-fns*
	      '(qplot-arrowhead qplot-axis-label qplot-bezier-curve qplot-bracket 
		qplot-box qplot-box-label qplot-circle
		qplot-cubic-spline qplot-dashed-line qplot-dot
		qplot-ellipse qplot-end-display qplot-functional-spline qplot-hline
		qplot-line qplot-lines  qplot-lines-with-arrowhead qplot-new-behavior
		qplot-polygon qplot-ring qplot-sideways-string qplot-string
		qplot-string-on-clean qplot-string-w-infinity qplot-x-centered-string 
		qplot-special-char qplot-spline qplot-symbol
		qplot-superscripted-string qplot-vector qplot-vline
		qplot-right-justified-string
		qplot-undo ; BKay 27Jun92
		))   

(defparameter *exports*
              (append *drawing-fns*
	              '(*allow-plotting* *ask-for-postscript-output* *axis-font-height*
		        *black* *bounding-box* *current-font* *default-directory*
			*dot-font* *drawing-fns* *exports* *flip* *grayval*
			*image-disposal* *linewidth* *picture* *plain-font* *postscript-bound*
			*postscript-output-file* *postscript-style*
			*ps-control-menu-entry*  *ps-menu-choices*
			*ps-out-readtable* *qplot-output* *rotation*
			*size-translations* *symbol-ps-size* *symbol-x-offset*
			*symbol-y-offset* *Text-Format-text-height* *text-format-text-width* *used-fonts*
			*wizard-option-list* *white* *x-scale* *x-translation* *y-scale*
			*y-translation* axis-font bounding-box bracket-lists checkgray checkwidth
			dec device-interface end-postscript-file fp get-font-for-string get-postscript-file
			ign image-to-postscript-p image-to-screen-p inc
			initialize-postscript-variables label-font left
			maybe-hardcopy-image merge-font-info
			postscript-wizard-options ps-draw-box
			ps-draw-circle ps-draw-cubic-spline ps-draw-dashed-line
			ps-draw-filled-in-circle ps-draw-line ps-draw-lines
			ps-draw-point ps-draw-polygon ps-draw-rectangle ps-draw-ring
			ps-draw-string ps-draw-vector ps-end-image ps-new-behavior
			ps-string ps-trim resizing right set-ps-control-variables 
			size-translation start-postscript-file std strip-font-info test-pos
			triangle-point-translation with-plotting-to-postscript-inhibited
			with-plotting-to-screen-forced with-plotting-to-screen-inhibited
			with-plotting-to-postscript-forced xscreen yscreen

			;; Additions by BKay 26Jun92.  This is the result of moving qgraph
			;; into xpos and adding lispview support.
			with-qplot-gcon

			;; queue manipulation stuff BKay 5Jun92
			make-q qpush qpop qlist qempty qtop qlength
			qpop-backend make-queue
			
			;; qgraph calls
			create-line create-qgraph qgs qds
			qgraph-read-file qgraph-write-file
			qgraph-structure-wrapped qgraph-structure
			qgraph-display
			qgraph-add-point qgraph-add-trend
			
			show-qg show-ds
			*current-qgraph* *datasets* *qgraphs*
			
			+inf -inf
			markers errorbars
			box axis plain-box box-center
			
			;; These are for backward compatabilty
			make-qgraph make-line make-tqual make-tenv
			qgraph-data qgraph-colors qgraph-styles
			line-data qgraph-data

			;; Additions to handle new method of plotting
			close-postscript-file-if-needed set-image-disposal
			get-and-open-postscript-file
			)))



;;;  Export the POS functions and then import them into qsim.  If the qsim package has
;;;  not been defined, then create it first.  This will cause the qsim package to be 
;;;  needlessly created when xpos is used without qsim.  It has been included
;;;  because of problems importing the pos functions within the nq.system
;;;  definition due to the Common Lisp defsystem.


(export pos::*exports* 'pos)

(unless (find-package 'qsim)
  (make-package 'qsim
		:use '(lisp)))					; inherit from pure Common Lisp

(import pos::*exports* 'qsim)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;           SYSTEM-DEPENDENT CODE FOR THE X-WINDOWS VERSION OF XPOS
;;;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;  Define the binary directory for xpos.
#+(and :mk-defsystem (not :ccl))
(let ((*qsim-root* "/v/deepthought/v0/qr")
      (*bin-dir-component*
       #+:pos-lispview (format nil "~a_lispview"
			       (mk::afs-component
				(mk::machine-type-translation (machine-type))
				(mk::software-type-translation (software-type))))
       #-:pos-lispview (format nil "~a"
			       (mk::afs-component
				(mk::machine-type-translation (machine-type))
				(mk::software-type-translation (software-type))))))
  (declare (special *qsim-root*))
  
  (setf *xpos-bin-dir*
	(format nil 
		"~a/xpos/bins/~a/"
		*qsim-root*
		*bin-dir-component*))

  
  (defparameter pos::*obj-dir*
                (format nil 
			"~a/xpos/bins/~a/"
			*qsim-root*
			*bin-dir-component*))

  #+:x-windows  (unless (probe-file (format nil "~a/xbatch" pos::*obj-dir*))
		  (error (format nil "xbatch was not found in ~a"
				 pos::*obj-dir*)))

  ;;;  The logical-pathname translations for xpos.

  (setf (lp:logical-pathname-translations "xpos")
	'(("xpos;*"                   (format nil "~a/xpos/" *qsim-root*))
	  ("ps;*"                     (format nil "~a/xpos/ps/" *qsim-root*))
	  ("bin;*"                    *xpos-bin-dir*)
	  ("bin;ps;*"                 *xpos-bin-dir*))))
  
#+:ccl
(progn
  ;(in-package 'user)
  (ccl::def-logical-pathname "xpos:xpos;"     (format nil "~a:xpos:" user::*qsim-root*))
  (ccl::def-logical-pathname "xpos:ps;"       (format nil "~a:xpos:ps:" user::*qsim-root*))
  (ccl::def-logical-pathname "xpos:bin;"      (format nil "~a:xpos:" user::*qsim-root*))
)


;;;   Common Lisp defsystem.
;;;
#+:mk-defsystem
(mk:defsystem xpos
     :host "ai"
     :source-pathname       "xpos:xpos;"
     :source-extension      "lisp"
     :package               pos
     :binary-pathname       #-:ccl"xpos:bin;"
                            #+:ccl nil
     :finally-do            (pushnew :pos *features*)
     :components
     ((:module core
	       :source-pathname ""
	       :components
	          (#-(or :lcl3.0 :lcl4.0 :loop) 
		     (:file "loop"
			    :depends-on nil)
		  (:file "postscripter")
		  (:file "qplot-primitives"
		       :depends-on ("postscripter"))
		(:file "qplot-advanced"
		       :depends-on ("qplot-primitives"))
		(:file "pplot"
		       :depends-on ("qplot-advanced"))
		(:file "machine-params"
		       :depends-on ("qplot-advanced"))
		(:file "pos-usrintface"
		       :depends-on ("machine-params"))
		#+:pos-lispview
		(:file "lispview-extensions"
		       :depends-on ("qplot-primitives" "machine-params"))
		)
	       :depends-on nil)
      (:module qgraph
	       :source-pathname ""
	       :components
	       ((:file "qgraph")
		(:file "qgraph-io"
		       :depends-on ("qgraph")))
	       :depends-on (core))
      #+:pos-lispview
      (:module clos
	       :source-pathname ""
	       :components
	       ((:file "clos-dispatcher"))
	       :depends-on (qgraph))
      :depends-on nil))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;
;;;           SYSTEM-DEPENDENT CODE FOR THE SYMBOLICS MACHINE
;;;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

#+symbolics
(unless (fs:get-logical-pathname-host "XPOS" t)
  (fs:set-logical-pathname-host "Xpos"
				:physical-host "ai"
				:translations '(("Xpos;" "/v/deepthought/v0/qr/xpos/")
						("PS;"   "/v/deepthought/v0/qr/xpos/ps/")	; subdirectory for ps files 
						("Xpos; Patch;" "sancho:>PostScript>Patch>"))
				:no-search-for-shadowed-physical t))


;;; The inclusion of the alternate TI files in the 3600's DEFSYSTEM
;;; means that when dumping the system, everybody gets both versions of
;;; the system.

#+symbolics
(sct::defsystem xPOS
           (:default-package Pos
            :default-pathname "xPOS:xPOS;"
            :patchable nil
            :initial-status :experimental)
           (:module extra-code ("TI-Machine-Params"  "TI-POS-UsrIntface")
	                       (:type :lisp-example))			
           (:serial "Postscripter"		; No machine dependent code
	            "Qplot-Primitives"		; Machine-dependent code, shared w/ readmacros
	            "Qplot-Advanced"		; Machine-dependent code, shared w/ readmacros
					;    -advanced features.
	            "Pplot"			; No machine dependent code
	            "Machine-Params"		; Specific to Symbolics
	            "Symbolics-Extensions"	; Specific to Symbolics
	            "POS-UsrIntface"		; Specific to Symbolics
		    "qgraph"                    ; semiquant display functions
		    "qgraph-io"                 ; ditto
		    ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;
;;;            SYSTEM-DEPENDENT CODE FOR THE TI EXPLORER
;;;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


#+ti
(sys::defsystem xPOS
           (:name "XPOS")
           (:package Pos)
           (:pathname-default "XPOS:XPOS;")
	   (:default-output-directory "xPOS:xpos-bin;")
	   (:patchable nil)
;          (:patchable "xpos:pos-patch;" patch)
           (:output-version :higher)
           (:serial t)

           (:module POSTSCRIPTER "Postscripter")
           (:module PRIMITIVES	("Qplot-Primitives" "Qplot-Advanced"))
           (:module PPLOT	("Pplot" "TI-Machine-Params" "TI-POS-UsrIntface"))
	   (:module QGRAPH      ("qgraph" "qgraph-io"))

           (:compile-load POSTSCRIPTER)
           (:compile-load-init PRIMITIVES (postscripter))
           (:compile-load-init PPLOT	  (primitives postscripter))
	   (:compile-load-init QGRAPH     (primitives postscripter pplot)))




;;; The definition of this pathname is system-specific.  However, the
;;; following definition is both TI and 3600 compatible.

(defparameter pos:*default-directory*
	      #+symbolics                   "Xpos:PS;*.*.newest"
              #+explorer                    "Xpos:PS;"
	      #+:mk-defsystem               "xpos:ps;*"
              #+(and unix
		     (not :mk-defsystem))   "xpos/ps")


