;;; -*- Mode:Common-Lisp; Package:POS; Syntax:COMMON-LISP; Default-character-style:(FIX BOLD NORMAL); Base:10 -*-
;;; Copyright 1988 David Throop at the University of Texas at Austin



(in-package :pos)

#+:ccl
(use-package :ccl :pos)

#+symbolics
(use-package :scl :pos)

#+symbolics
(import '(self send defmethod))


;;; FOR testinf only

(defun l-pu () (load "pos-usrintface.lisp"))


;;; This file presents Device-Dependent code for user interface functions.   These include 
;;; menues, prompts for filenames and Command Level prompts.


;;; Add an option for changing the PostScript parameters to the CONTROL-VARIABLES menu.


(defparameter *ps-control-menu-entry*
	      #+(or symbolics ti)
              '("PS controls"
	        :eval            (set-ps-control-variables)
	        :character-style (nil :bold nil)
	        :documentation   "Send Output to PostScript File")
	      #-(or symbolics ti)
	      nil)

(defparameter *ps-menu-choices*
	      #+(or symbolics ti)
              '((*default-directory*
		 "Postscript Output" :documentation
		 "Behavior names will be merged against this to give default files for screen image"
		                     :pathname)
		(*image-disposal*  "Send Images to" :menu-alist
				   (("Nowhere" :value :none :documentation
				     "Image is not generated, but program is run thru paces")
				    ("Screen" :value :screen)
				    ("PostScript File" :value :PS)("Both" :value :both)))
		(*postscript-style* "PostScript Style" :menu-alist
				    (("Standard" :value :Standard
				      :documentation "Normal output for immediate hardcopy")
				     ("Bounded" :value :bounded
				      :documentation "For Inclusion in LaTeX using PSFIG")
				     ("Text-Format-Insert" :value :Text-Format-Insert :documentation
				      "Special style for inclusion in TEXT-FORMAT documents")
				     ("MS" :value :ms-word :documentation
				      "For inclusion in MS-WORD documents")))
		(*Text-Format-text-width* "Formatted Text Width" :number
					  :documentation "Width of the figure of Text-Format output")
		(xscreen "Screen Width" :number :documentation
			 "Screen Width in Pixels")
		(yscreen "Screen Height" :number :documentation
			 "Screen Height in Pixels"))
	      #-(or symbolics ti)
	      nil)


;;; Set varibles for PostScript Output.  Refuse to take a default
;;; directory if FS:PARSE-PATHNAME complains.


#-:ccl
(defun set-ps-control-variables ()
       #+(or symbolics ti)	(Tv:choose-variable-values *ps-menu-choices*
                                                           :extra-width 66
                                                           :label       "Put QSIM plots in a PostScript File")
       #-(or symbolics ti)      (progn (format t "~%Send Images to [s screen / f file / b both / n nowhere] -> ")
				       (clear-input t)
                                       (let ((choice           (string-upcase (string (read t)))))
					    (cond ((equal choice "S")	(setq *image-disposal* :screen))
                                                  ((equal choice "F")	(setq *image-disposal* :ps))
                                                  ((equal choice "N")   (setq *image-disposal* :none))
                                                  (t			(setq *image-disposal* :both))))) )

       

#+:ccl
(defun set-ps-control-variables ()
       (DECLARE (SPECIAL *IMAGE-DISPOSAL*))
       (SETQ *IMAGE-DISPOSAL* :SCREEN)
       (let ((tt
(ONEOF *DIALOG*
       :WINDOW-TYPE :DOUBLE-EDGE-BOX :WINDOW-POSITION '(:TOP 60)
       :WINDOW-SIZE (make-point 300 150)
       :CLOSE-BOX-P NIL
       :DIALOG-ITEMS
       (LIST (MAKE-DIALOG-ITEM *STATIC-TEXT-DIALOG-ITEM*
                               (make-point 20 15)
                               (make-point 89 16)
                               "Output to"
                               NIL)
             (MAKE-DIALOG-ITEM *RADIO-BUTTON-DIALOG-ITEM*
                               (make-point 50 50)
                               (make-point 72 16)
                               "Screen"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (DECLARE (SPECIAL *IMAGE-DISPOSAL*))
                                           (SETQ *IMAGE-DISPOSAL* :SCREEN)
                                           (USUAL-DIALOG-ITEM-ACTION)))
                               :RADIO-BUTTON-PUSHED-P T)
             (MAKE-DIALOG-ITEM *RADIO-BUTTON-DIALOG-ITEM*
                               (make-point 50 71)
                               (make-point 72 16)
                               "File"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (DECLARE (SPECIAL *IMAGE-DISPOSAL*))
                                           (SETQ *IMAGE-DISPOSAL* :PS)
                                           (USUAL-DIALOG-ITEM-ACTION))))
             (MAKE-DIALOG-ITEM *RADIO-BUTTON-DIALOG-ITEM*
                               (make-point 50 92)
                               (make-point 72 16)
                               "Both"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (DECLARE (SPECIAL *IMAGE-DISPOSAL*))
                                           (SETQ *IMAGE-DISPOSAL* :BOTH)
                                           (USUAL-DIALOG-ITEM-ACTION))))
             (MAKE-DIALOG-ITEM *RADIO-BUTTON-DIALOG-ITEM*
                               (make-point 50 113)
                               (make-point 93 16)
                               "Nowhere"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (DECLARE (SPECIAL *IMAGE-DISPOSAL*))
                                           (SETQ *IMAGE-DISPOSAL* :NONE)
                                           (USUAL-DIALOG-ITEM-ACTION))))
             (MAKE-DIALOG-ITEM *BUTTON-DIALOG-ITEM*
                               (make-point 200 76)
                               (make-point 62 16)
                               "Cancel"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (RETURN-FROM-MODAL-DIALOG :CANCEL)))
                               :DEFAULT-BUTTON NIL)
             (MAKE-DIALOG-ITEM *BUTTON-DIALOG-ITEM*
                               (make-point 201 104)
                               (make-point 62 16)
                               "OK"
                               (NFUNCTION DIALOG-ITEM-ACTION
                                          (LAMBDA
                                           NIL
                                           (RETURN-FROM-MODAL-DIALOG T)))
                               :DEFAULT-BUTTON T)))))
       (modal-dialog tt)))





;;; POSTSCRIPT-WIZARD-OPTIONS allows changing dimensions for special
;;; output needs, eg legal-sized paper or for students with bad
;;; astigmatisms.

#+(or symbolics ti)
(defparameter *wizard-option-list*
	      '((*x-translation* :number :documentation
				 "Distance from lower left corner, in inches, along bottom of page to X = 0")
		(*y-translation* :number :documentation
				 "Distance from lower left corner, in inches, along side of page to Y = 0")
		(*rotation*
		  :number :documentation
		  "Rotation of x,y coordinates.  0 means y is the side and x is the bottom of paper.")
		(*x-scale*			; These are normally rebound dynamically, anyway,
		  :number :documentation	;   so changing them makes no difference.
		  "Compression of X axis, used to fit output on page [negative values print backwards]")
		(*y-scale* :number :documentation
			   "Compression of Y axis, used to fit output on page")))



#+(or symbolics ti)                      ;;; 01/23/91 - wkk
(defun postscript-wizard-options ()
      (tv:choose-variable-values *wizard-option-list*
                                 :Label "  Alter these to get differently shaped output  "))



;;; The postscript image must be written to a file before it is printed.  The next two
;;; forms query about the name of the file to be created to do this.  The third form asks
;;; the user whether to dispatch the completed PS file to the printer.

;;; Concatinate the NAME of the initial QDE onto *default-directory*.  Get the name
;;; from the initial state.  

(defparameter *picture* :picture)
(defparameter *ask-for-postscript-output* t)



#-(or symbolics ti)
(defun gpf-get-pathname (dir)
       #+:mk-defsystem    (cond #+:logical-pathnames-mk
                                ((eql (lp:pathname-host-type dir) :logical)
                                      (directory-namestring (lp:translate-logical-pathname dir :namestring)))
                                (t    (directory-namestring dir)))
       #-:mk-defsystem    (directory-namestring dir))



#-(or symbolics ti)
(defun gpf-get-file-name ()
       (let ((file-name       (read-line t)))
            #+:mk-defsystem   (cond #+:logical-pathnames-mk
                                    ((eql (lp:pathname-host-type file-name) :logical)
                                          (lp:translate-logical-pathname file-name :namestring))
                                    (t    file-name))
            #-:mk-defsystem   file-name))


;;; BKay 3Sept91  - added a readtime conditional for allegro because filenames
;;; like "foo" don't return :relative, they return nil.
(defun get-postscript-file ()			
       #+(or symbolics ti)
       (let ((nm      (fs:merge-pathnames (format nil "~(~a~).ps" *picture*) *default-directory*)))
	 (if *ask-for-postscript-output* 
	     (zl:prompt-and-read `(:pathname :visible-default ,nm
					     ;; This permits nil filenames on ti and symb
					     :or-nil t)
				 "PostScript output to what file? ")
	
                                   nm))


       #+(and :mk-defsystem (not (or symbolics ti)))
       (let ((dir     (gpf-get-pathname *default-directory*)))
	 (format t "Filename (Default Directory: ~a): " dir)
	 (clear-input t)
	 (let ((file-name     (gpf-get-file-name)))
	   (unless (equal file-name "")
	   (terpri)
           ;; Modified DJC 21 Oct 91 for the Mac
	   (cond (#-(or allegro-v4.0 :ccl)
                  (member :relative (pathname-directory file-name))
                  #+:ccl
                  (null (pathname-directory file-name))
                  (merge-pathnames file-name dir)
		  #+:allegro-v4.0
                  (or (null (pathname-directory file-name))
                      (member :relative (pathname-directory file-name)))
                  (merge-pathnames file-name dir))
		 (t    file-name) ))))
;;;       #+:ccl                 (choose-new-file-dialog :prompt "Postscript filename")
       #-(or :mk-defsystem symbolics ti)
       (progn
	 (format t "~%Filename: ")
	 (clear-input t)
	 (let ((file-name             (read-line t)))
	   (terpri) file-name)))







(defparameter *ask-for-postscript-hardcopy* t)


#+(or symbolics ti)
(defun maybe-hardcopy-image (filename &key (tv nil)(print-cover-pages)
			     &aux (qstring (format nil "  Hardcopy File ~a?   "
						   filename)))
  (when (and *ask-for-postscript-hardcopy*
	     (member *postscript-style* '(:bounded :standard))
	     (if tv
		 (tv:mouse-y-or-n-p qstring)
		 (zl:fquery () qstring)))
    (hardcopy:hardcopy-file
      filename hardcopy:*default-text-printer* :format :lgp2
      :notify-requestor nil
      :print-cover-pages print-cover-pages)))

#+unix
(defun maybe-hardcopy-image (filename &key (tv nil)(print-cover-pages)
			     &aux (qstring (format nil "  Hardcopy File ~a?   "
						   filename)))
  (declare (ignore tv print-cover-pages qstring))
  nil)




;;; On Symbolics, in addition to executing LISP forms, there is a Command level, with
;;; handy help facilities etc.  The following forms implement several of the most common
;;; POS commands for the Command level.

#+symbolics
(cp:define-command (com-PostScript-Change-Control-Variables
		     :provide-output-destination-keyword nil
		     :command-table "Global")
    ()
   (Set-ps-Control-Variables))


#+symbolics
(cp:define-command (com-PostScript-no
		     :provide-output-destination-keyword nil
		     :command-table "Global")
    ()
   (setf *image-disposal* :screen))


#+symbolics
(cp:define-command (com-PostScript-yes
		     :provide-output-destination-keyword nil
		     :command-table "Global")
    ()
   (setf *image-disposal* :both))



#+symbolics
(cp:define-command (com-PostScript-Wizard-Options
		     :provide-output-destination-keyword nil
		     :command-table "Global")
    ()
   (postscript-wizard-options))





