;;; -*- Mode: Common-Lisp; Package: Qsim; Base: 10 -*-

(in-package 'QSIM)

;;; This file contains Common Lisp code used in both the Viewers-Misc and the
;;; Viewers-Clisp files.  Refer to Read-Me-About-Viewers for more details.

(proclaim '(special tmargin))


;; Return list of bnums specified by Begin and End.

(defun SEQUENCE-OF-NUMS (begin end btotal)
  (if (= begin end)
      (if (or (< begin 1) (> end btotal))
	  nil
	  (list begin))
      (if (> end begin)
	  (determine-num-sequence begin end btotal)
	  (determine-num-sequence end begin btotal))))


(defun DETERMINE-NUM-SEQUENCE (begin end btotal)
  (cond ((< end 1) nil)
	((> begin btotal) nil)
	(t (return-num-sequence (if (< begin 1) 1 begin)
				(if (> end btotal) btotal end)))))


(defun RETURN-NUM-SEQUENCE (begin end)
  (cond ((= begin end) (list end))
	(t (cons begin (return-num-sequence (1+ begin) end)))))


;; Determine bnum specified by clicking at the behavior tree.

(defun DETERMINE-BNUM-FROM-POSITION (y btotal)
  (1+ (truncate (/ (+ (- y tmargin 50)
		      (/ (min (round (/ 500. btotal)) 20.) 2))
		   (min (round (/ 500. btotal)) 20.)))))


;;; Added the tree-ystep keyword to create fixed-distance tree plots.
;;; BKay 3Feb92
;;;
(defun QPLOT-BEHAVIOR-TREE (inits max-len btotal bnum
				  &key (tree-ystep nil))
  (qplot-new-behavior)
  (qplot-tree-label inits btotal)
  (plot-state-tree inits max-len btotal 40. tmargin 500. 500. bnum
		   :tree-ystep tree-ystep)
  (qplot-end-display))


(defun QPLOT-TREE-LABEL (inits btotal)
  (let ((text (qde-text (state-qde (car inits))))
	(name (qde-name (state-qde (car inits)))))
    (loop for string in
	  (list (format nil "Structure: ~A" (if (or (null text) (equal text "")) name text))
		(format nil "Simulation from ~A complete initialization~:P." (length inits))
		(format nil "A total of ~A behavior~:P." btotal))
	  for y from 25 by 14
	  do (qplot-string string 15 y))))

