;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)

;       Copyright (c) 1987, Benjamin Kuipers.

; Abstraction properties:
;   faster:             set of mechanisms
;   slower:             set of mechanisms
;   abstracted-from:    alist of (constraint mechanism)
;   abstracted-to:      set of (constraint corr-vals assumptions)

; EXPERIMENT-6:  Run water balance, then automatically simulate across time-scales.

(defun two-level-simulation ()
  (setq *latest-states* nil)
  (assert-time-relations
    '((water-balance-naked (slower sodium-balance-naked)
			   (faster))
      (sodium-balance-naked (faster water-balance-naked)
			    (slower))))
  (let* ((normal (get-normal-state water-balance-naked))
	 (new (make-modified-state normal
				   `((afp   (,(normal-value 'afp normal) nil))
				     ; (wi    (,(normal-value 'wi  normal) nil))
				     (anp   (,(normal-value 'anp normal) std))
				     (nfnpu (,(normal-value 'nfnpu normal) std))
				     (nfwip (,(higher-than-normal 'nfwip normal) std)))
				   "Increased water intake."
				   ))
	 (hbehaviors (simulate-across-time-scales new)))
    (HQ-display hbehaviors)
    (if (y-or-n-p "Hierarchical slice display? ")
	(HQslice-plot '(nfwip afp anp cnp) hbehaviors))
    t))


(defun assert-time-relations (alist)
  (mapc #'(lambda (entry)
	    (let ((qde (eval (car entry))))	; because we have qde-NAMES here.
	      (mapc #'(lambda (clause)
			(replace-slot-contents qde (car clause) (cdr clause)))
		    (cdr entry))))
	alist))

(defun replace-slot-contents (qde slot contents)
  (let* ((other-slot (qde-other qde))
	 (clause (assoc slot other-slot)))
    (cond ((null clause)
	   (setf (qde-other qde) (cons (cons slot contents) other-slot)))
	  (t (setf (cdr clause) contents)))
    contents))
