;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)


; This is something I have not yet been able to make work.
; The hope is to handle damping directly through the energy terms.

(define-QDE Spring-with-energy-loss
   (quantity-spaces
	      (TE     (0 E* inf))
	      (A      (minf 0 inf))
	      (V      (minf 0 V* inf))
	      (X      (minf 0 inf))
	      (KE     (0 inf))
	      (PE     (0 inf))
	      (VSQ    (0 inf))
	      (XSQ    (0 inf))
	      (SUMXA  (minf 0 inf))
	      (dTE    (minf 0)))
   (constraints
	      ((d//dt X V))
	      ((d//dt V A))
	      ((M- A X)         (0 0) (minf inf) (inf minf))
	      ((mult V V VSQ))
	      ((mult X X XSQ))
	      ((M+ VSQ KE)      (0 0) (inf inf))
	      ((M+ XSQ PE)      (0 0) (inf inf))
              ((add KE PE TE))
	      ((add X A SUMXA))
	      ((mult V SUMXA dTE))
	      ((d//dt TE dTE))
	      )
   (independent)
   (dependent X V A XSQ VSQ PE KE TE dTE)
   (history X V TE)
   (print-names  (TE  "Total Energy")
		 (A   "Accelleration")
		 (V   "Velocity")
		 (X   "Position")
		 (KE  "Kinetic Energy")
		 (PE  "Potential Energy")
		 (dTE "Total energy change")
		 (SUMXA  "X+A"  XA)
		 (VSQ)
		 (XSQ))
   (text "Spring with energy conservation")
   (layout  (x xsq pe)
	    (v vsq ke)
	    (a dte te)
	    (nil sumxa))
   )




(defun push-spring-w-energy-loss ()
  (let ((initial
	  (make-initial-state spring-with-energy-loss
			      '((te (E* nil))
				(x  (0 nil))
				(dte (0 std))
				(v  (V* nil))))))
    (qsim initial)
    (qsim-display initial nil)		; no reference points yet.
    ))

