;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package 'QSIM)

; Double Heat-Flow Example from AI Journal paper.

(define-structure Double-Heat-Flow
  (functions T-air T T-source dTA dTS outflow inflow netflow)
  (constraints
   (add T-air dTa T (airtemp 0 airtemp))
   (add T dTS T-source (flametemp 0 flametemp))
   (M0+ dTA outflow)
   (M0+ dTS inflow)
   (add outflow netflow inflow)
   (d//dt T netflow))
  (landmarks
   (T-air    (minf 0 airtemp flametemp inf))
   (T        (minf 0 airtemp flametemp inf))
   (T-source (minf 0 airtemp flametemp inf)))
  (invariants
   (T-air (airtemp std))
   (T-source (flametemp std))))

; This starts with T = airtemp, which should proceed without problem
; to an equilibrium point.
; Unfortunately, in spite of appearances, T-air, T, and T-source do not
; share a quantity space:  they only have similarly spelled landmarks.
; This is why the add constraints need those odd correspondences.

(define-initialization double-heat-flow initialize-double-heat-flow
  ((T (airtemp nil))
   (dTA (0 nil))
   (dTS ((0 inf) nil))))

; This starts with airtemp < T < flametemp, which cannot be handled yet,
; because QSIM cannot branch on possible completions of the initial state.

;This has to be commented out for now while the conversion to the
;new DEFINE-INITIALIZATION is taking place. --CRE
;(define-initialization double-heat-flow underspecified-double-heat-flow
;  ((T ((airtemp flametemp) nil))))
