;;; -*- Syntax: Common-lisp; Package: qsim -*-
(in-package :qsim)

; This is essentially the Ball, except with a decreasing gravity field.
; This means that the rocket does not necessarily return to earth, since
; it might pass escape velocity and go on to infinity, so we get a branch.

; The constraint A = S+(Y) allows us to have a monotonic function
; constraint where A'(t)=0 while Y'(t)>0, so the rocket slows down
; asymptotically to a positive (non-zero) velocity.  This corrects a
; previous bug, where that behavior was excluded.

(define-QDE rocket
  (text  "Rocket:  projectile with initial velocity and decreasing gravity.")
  (quantity-spaces
    (y   (minf 0 inf))
    (v   (minf 0 v* inf))
    (a   (minf g 0)))
  (constraints
    ((d/dt v a))
    ((d/dt y v))
    ((s+ y a (minf minf) (inf 0))  (0 g))
    )
  (transitions
    ((y (0 dec)) -> t))
  (layout (nil nil nil y)
	  (nil nil nil v)
	  (nil nil nil a)
	  nil))

(defun fire-rocket ()
  (let ((initial
	  (make-new-state :from-qde      Rocket
			  :assert-values '((y  (0  nil))
					   (v  (v* nil))
					   (a  (g  nil)))
			  :text "Rocket shot upward")))
    (qsim initial)
    (qsim-display initial)))
