;;; -*- Syntax: Common-lisp; Package: QSIM -*-
(in-package :qsim)


; Reaction:  A + B --> C

(define-QDE Reaction
  (text "Reaction:  A + B --> C")
  (quantity-spaces
    (A      (0 inf))
    (B      (0 inf))
    (cA     (0 inf))
    (cB     (0 inf))
    (rate   (0 inf))
    (inflowA  (0 inf))
    (inflowB  (0 inf))
    (outflowC (0 inf))
    (dA       (minf 0 inf))
    (dB       (minf 0 inf))
    (dC       (minf 0 inf))
    (C        (0 inf)))
  (constraints
    ((M+ A cA)  (0 0) (inf inf))
    ((M+ B cB)  (0 0) (inf inf))
    ((mult cA cB rate))
    ((add dA rate inflowA))
    ((add dB rate inflowB))
    ((add outflowC dC rate))
    ((d/dt A dA))
    ((d/dt B dB))
    ((d/dt C dC))
    ((constant inflowA))
    ((constant inflowB))
    ((constant outflowC)))
  (layout (A       B       C    nil)
	  (cA      cB      rate)
	  (inflowA inflowB outflowC)
	  (dA      dB      dC))
)

; Run the reaction


(defun run-reaction ()
  (let* ((normal (make-new-state :from-qde Reaction
				 :assert-values'((A     ((0 inf) std))
						 (B     ((0 inf) std))
						 (C     ((0 inf) std))
						 (inflowA   ((0 inf) std))
						 (inflowB   ((0 inf) std))
						 (outflowC   ((0 inf) std)))
				 :text "Equilibrium state"))
	 (missing (make-new-state :from-state normal
				  :assert-values '((inflowA (0 std)))
				  :inherit '(A B C inflowB outflowC)
				  :text "cut off supply of A")))
    (qsim missing)
    (qsim-display missing
		  :reference-states `((normal ,normal)))))


(defun fixed-resources ()
  (let* ((init (make-new-state :from-qde Reaction
			       :assert-values '((A     ((0 inf) nil))
						(B     ((0 inf) nil))
						(C     (0 nil))
						(inflowA   (0 std))
						(inflowB   (0 std))
						(outflowC  (0 std)))
			       :text "Use fixed resources")))
    (qsim init)
    (qsim-display init)))