;;; -*- Mode:Common-Lisp; Package:QSIM; Base:10 -*-


;;;*****************************************************************************
;;;			 E N V I S I O N M E N T
;;;
;;; Pierre Fouche
;;; Septembre 1990
;;;
;;; Functions in this file perform envisionment.
;;; If *develop-graph* is T, the graph is enumerated and all the behaviors are
;;; displayed.
;;; If *develop-graph* is nil, only the envisionment graph is displayed. 
;;; Bold lines represent a spanning tree of that graph.
;;;*****************************************************************************


;;;=============================================================================
;;;				  S P R I N G S
;;;=============================================================================

;;;-----------------------------------------------------------------------------
;;; The simple spring-block system
;;;-----------------------------------------------------------------------------

(define-QDE Spring1
   (text "Simple spring.")
   (quantity-spaces
     (x  (minf 0 inf))
     (v  (minf 0 inf))
     (a  (minf 0 inf)))
   (constraints
     ((d/dt x v))
     ((d/dt v a))
     ((M- a x)   (0 0) (minf inf) (inf minf)))
   (layout nil nil (x v a)))
   
(defun ss()
  (qsim-cleanup)
  (qsim-display (envision :qde spring1
			  :values
			  ;nil
			  '((x ((0 inf) std)))
			  )))


;;;-----------------------------------------------------------------------------
;;; The Damped Spring
;;;-----------------------------------------------------------------------------

(define-QDE Spring3
  (quantity-spaces
    (x     (minf 0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf))
    (ff    (minf 0 inf))
    (fs    (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x fs)    (0 0)  (minf inf)  (inf minf))
    ((m- v ff)    (0 0)  (minf inf)  (inf minf))
    ((add fs ff a)))
  (no-new-landmarks a)
  (ignore-qdirs a)
  (layout  (x fs )
	   (v ff)
	   (a)))

(defun ign-sf()
  (qsim-cleanup)
  (qsim-display (envision :qde spring3
			  :values
			  '((x ((0 inf) std)))
			  )))

;;;-----------------------------------------------------------------------------
;;; The Damped Spring, with ACC and NIC
;;;-----------------------------------------------------------------------------

(define-QDE Spring4
  (quantity-spaces
    (x     (minf 0 inf))
    (v     (minf 0 inf))
    (a     (minf 0 inf))
    (ff    (minf 0 inf))
    (fs    (minf 0 inf)))
  (constraints
    ((d/dt x v))
    ((d/dt v a))
    ((m- x fs)    (0 0)  (minf inf)  (inf minf))
    ((m- v ff)    (0 0)  (minf inf)  (inf minf))
    ((add fs ff a)))

  (layout  (x fs )
	   (v ff)
	   (nil a)))


(defun sf()
  (qsim-cleanup)
  (qsim-display (envision :qde spring4
			  :values
			  '((x ((0 inf) std)))
			  )))


;;;=============================================================================
;;;			  A -> B -> C -> D -> E
;;;=============================================================================
				    
;This qde models an isothermal batch reactor with 4 1st-order irreversible
;reactions in series A -> B -> C -> D -> E occurring.  The modeling equations 
;are:
;
; dCa/dt = -k1Ca
;
; dCb/dt = k1Ca - k2Cb
;
; dCc/dt = k2Cb - k3Cc
;
; dCd/dt = k3Cc - k4Cd
;
; dCe/dt = k4Ci
;
;where ki = KiCao*A/Fa (C = concentration, F = Flow rate, A = cross sectional area), 
;for a flow system.  (The Ki's are the first-order reaction rate constants).
;
;(11/15/88).
;
;This QDE should be run with *accept-only-analytical-solutions*, *perform-acc-analysis*,
;and *auto-sd3-evaluation* set to T to avoid impossible behaviors.  Also, *state-limit* 
;should be at least 1500.
;
;The QDE generates 39 behaviors after simulating 1435 states.  This is equivalent to the 
;behavior of a plug-flow reactor of infinite length with the same kinetics.
;


(define-qde batch-a->b->c->d->e
  (text "Isothermal batch CSTR reactor for the reactions A -> B -> C -> D -> E")
  (quantity-spaces
    (-cao (minf cao 0))
    (k1 (0 k1 inf))
    (k2 (0 k2 inf))
    (k3 (0 k3 inf))
    (k4 (0 k4 inf))
    (ca (0 cao inf))
    (cb (0 cao inf))
    (cc (0 cao inf))
    (cd (0 cao inf))
    (ce (0 cao inf))
    (ra (0 inf))
    (rb (0 inf))
    (rc (0 inf))
    (dca/dt (minf 0 inf))
    (dcb/dt (minf 0 inf))
    (dcc/dt (minf 0 inf))
    (dcd/dt (minf 0 inf))
    (dce/dt (minf 0 inf)))
  (constraints
    ((mult k1 ca ra))
    ((mult k2 cb rb))
    ((mult k3 cc rc))
    ((mult k4 cd dce/dt))
    ((minus dca/dt ra))
    ((add dcb/dt rb ra))			
    ((add dcc/dt rc rb))
    ((add dcd/dt dce/dt rc))
    ((sum-zero ca cb cc cd ce -cao)
     (cao 0 0 0 0 cao) (0 cao 0 0 0 cao) (0 0 cao 0 0 cao) (0 0 0 cao 0 cao) (0 0 0 0 cao cao))
    ((sum-zero dca/dt dcb/dt dcc/dt dcd/dt dce/dt))
    ((d/dt ca dca/dt))
    ((d/dt cb dcb/dt))				
    ((d/dt cc dcc/dt))				
    ((d/dt cd dcd/dt))				
    ((d/dt ce dce/dt)))				
  (independent k1 k2 k3 k4 -cao)
;  (history ca cb cc cd ce dca/dt dcb/dt dcc/dt dcd/dt dce/dt ra rb rc)
;  4 behavior with this and no acc
;  (other (ignore-qdirs dcb/dt dcc/dt dcd/dt dce/dt))	
  (print-names
    (ca "Concentration of A" ca)
    (cb "Concentration of B" cb)
    (cc "Concentration of C" cc)
    (cd "Concentration of D" cd)
    (ce "Concentration of E" ce)
    (-cao "Initial Concentration of A" cao)
    (dca/dt "dcA/dt" dca)
    (dcb/dt "dcB/dt" dcb)
    (dcc/dt "dcC/dt" dcc)
    (dcd/dt "dcD/dt" dcd)
    (dce/dt "dcE/dt" dce))
  (layout
    (ca dca/dt)
    (cb dcb/dt)
    (cc dcc/dt)
    (cd dcd/dt)
    (ce dce/dt nil))
  )


(defun batch-a->b->c->d->e-text ()
  (format t "~2%This qde models an isothermal batch reactor with 4 1st-order irreversible")
  (format t "~%reactions in series A -> B -> C -> D -> E occurring.  The modeling equations")
  (format t "~%are:")
  (format t "~2%  dCa/dt = -k1Ca")
  (format t "~2%  dCb/dt = k1Ca - k2Cb")
  (format t "~2%  dCc/dt = k2Cb - k3Cc")
  (format t "~2%  dCd/dt = k3Cc - k4Cd")
  (format t "~2%  dCe/dt = k4Ci")
  (format t "~2%where the ki's are the first-order reaction rate constants."))


(defun abcde ()
  (let ((*perform-acc-analysis* t)
	(*analytic-functions-only* t))
    (batch-a->b->c->d->e-text)
    (qsim-cleanup)
    (qsim-display
      (envision :qde batch-a->b->c->d->e
		:values
		'((k1 (k1 std))
		  (k2 (k2 std))
		  (k3 (k3 std))
		  (k4 (k4 std))
		  (-cao (cao std))
		  (ca (cao nil))
		  (cb (0 nil))
		  (cc (0 nil))
		  (cd (0 nil))
		  (ce (0 nil)))))))
