;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

(in-package :qsim) ;changed DJC

;;;*****************************************************************************
;;;This qde models an isothermal batch reactor with 4 1st-order irreversible
;;;reactions in series A -> B -> C -> D -> E occurring. 
;;;*****************************************************************************

(define-qde batch-a->b->c->d->e
  (text "Isothermal batch CSTR reactor for the reactions A -> B -> C -> D -> E")
  (quantity-spaces
    (-cao (minf cao 0))
    (k1 (0 k1 inf))
    (k2 (0 k2 inf))
    (k3 (0 k3 inf))
    (k4 (0 k4 inf))
    (ca (0 cao inf))
    (cb (0 cao inf))
    (cc (0 cao inf))
    (cd (0 cao inf))
    (ce (0 cao inf))
    (ra (0 inf))
    (rb (0 inf))
    (rc (0 inf))
    (dca/dt (minf 0 inf))
    (dcb/dt (minf 0 inf))
    (dcc/dt (minf 0 inf))
    (dcd/dt (minf 0 inf))
    (dce/dt (minf 0 inf)))
  (constraints
    ((mult k1 ca ra))
    ((mult k2 cb rb))
    ((mult k3 cc rc))
    ((mult k4 cd dce/dt))
    ((minus dca/dt ra))
    ((add dcb/dt rb ra))			
    ((add dcc/dt rc rb))
    ((add dcd/dt dce/dt rc))
    ((sum-zero ca cb cc cd ce -cao)
     (cao 0 0 0 0 cao) (0 cao 0 0 0 cao) (0 0 cao 0 0 cao) (0 0 0 cao 0 cao) (0 0 0 0 cao cao))
    ((sum-zero dca/dt dcb/dt dcc/dt dcd/dt dce/dt))
    ((d/dt ca dca/dt))
    ((d/dt cb dcb/dt))				
    ((d/dt cc dcc/dt))				
    ((d/dt cd dcd/dt))				
    ((d/dt ce dce/dt)))				
  (independent k1 k2 k3 k4 -cao)
  (print-names
    (ca "Concentration of A" ca)
    (cb "Concentration of B" cb)
    (cc "Concentration of C" cc)
    (cd "Concentration of D" cd)
    (ce "Concentration of E" ce)
    (-cao "Initial Concentration of A" cao)
    (dca/dt "dcA/dt" dca)
    (dcb/dt "dcB/dt" dcb)
    (dcc/dt "dcC/dt" dcc)
    (dcd/dt "dcD/dt" dcd)
    (dce/dt "dcE/dt" dce))
  (layout
    (ca dca/dt)
    (cb dcb/dt)
    (cc dcc/dt)
    (cd dcd/dt)
    (ce dce/dt))
  )


(defun batch-a->b->c->d->e-text ()
  (format t "~2%This qde models an isothermal batch reactor with 4 1st-order irreversible")
  (format t "~%reactions in series A -> B -> C -> D -> E occurring.  The modeling equations")
  (format t "~%are:")
  (format t "~2%  dCa/dt = -k1Ca")
  (format t "~2%  dCb/dt = k1Ca - k2Cb")
  (format t "~2%  dCc/dt = k2Cb - k3Cc")
  (format t "~2%  dCd/dt = k3Cc - k4Cd")
  (format t "~2%  dCe/dt = k4Ci")
  (format t "~2%where the ki's are the first-order reaction rate constants."))


(defun abcde (analytic-functions-only-p hod-constraints-p)
  (qsim-cleanup)
  (qsim-display
    (envision :qde batch-a->b->c->d->e
	      :values
	      '((k1 (k1 std))
		(k2 (k2 std))
		(k3 (k3 std))
		(k4 (k4 std))
		(-cao (cao std))
		(ca (cao nil))
		(cb (0 nil))
		(cc (0 nil))
		(cd (0 nil))
		(ce (0 nil)))
	      :sim (make-sim :state-limit 800
			     :analytic-functions-only analytic-functions-only-p 
			     :hod-constraints hod-constraints-p))))


(defun abcde1 ()
  (abcde nil nil))

(defun abcde2 ()
  (abcde t nil))

(defun abcde3 ()
  (abcde nil t))

(defun abcde4 ()
  (abcde t t))


