;;; -*- Syntax: Common-Lisp; Package: QSIM -*-
(in-package :qsim)
;;; Copyright (c) 1991, Benjamin Kuipers.

;;;
;;;      Closed U-tube:  []<->[]
;;;

(define-component U-tube hydraulic "Closed U-tube"
  (components (A  compartment)
	      (B  compartment)
	      (P pipe)
	      (S1   stopper)
	      (S2   stopper))
  (connections (n0 (S1 in) (A in))
	       (n1 (A out) (P in))
	       (n2 (P out) (B out))
	       (n3 (B in) (S2 in))))

;;; To get the back-pressure, we connect the *outputs* of the tanks.
;;; Need the stoppers to avoid unconstrained inflows.


(defun test-U-tube ()
  (setq qde (build-qde 'U-tube))
  (let* ((sim (make-sim :HOD-constraints nil))
	 (init (make-CC-state  :from-qde qde
			       :sim sim
			       :assert-values '(((P K)      ((0 inf) std))
						((A amount)  ((0 inf) nil))
						((B amount)  (0 nil)))
			       :text "Start with A partly full, B empty"))
	 (cc-layout '(( (A amount)  (B amount)  (P k))
		      ( (A netflow) (B netflow) (P dp))
		      ( (A inflow)  (B outflow) ))))					 
    (qsim init)
    (cc-display init :layout cc-layout)
    init))


(defun perturb-U-tube ()
  (setq qde (build-qde 'U-tube))
  (let* ((sim (make-sim :HOD-constraints nil))
	 (ref (make-CC-state   :from-qde qde
			       :sim sim
			       :assert-values '(((P K)      ((0 inf) std))
						((A amount)  ((0 inf) std))
						((B amount)  ((0 inf) std)))
			       :text "Start with A and B partly full"))
	 (init (make-CC-state  :from-state ref
			       :perturb '(((A amount) +))
			       :inherit '((P K) (B amount))
			       :text "Add some extra to tank A"))
	 (cc-layout '(( (A amount)  (B amount)  (P k))
		      ( (A netflow) (B netflow) (P dp))
		      ( (A inflow)  (B outflow) ))))					 
    (qsim init)
    (cc-display init :layout cc-layout :reference-states `((N ,ref)))
    init))
