;;; -*- Mode: LISP; Syntax: Common-lisp; Package: QSIM; Base: 10 -*-


;;;
;;; Model Component Definitions
;;;

;;; Battery
(define-component
  battery
  (terminal-variables (t1 (v1 voltage independent)
			  (i1 current))
		      (t2 (v2 voltage independent)
			  (i  current display)))
  (component-variables (v voltage independent display))
  (constraints ((ADD v v2 v1))			; Voltage measured across terminals
	       ((MINUS i i1) (0 0) (inf minf)))    	; Battery current has opposite sign of outflow at t1
  )

;;; Capacitor
(define-component
  capacitor
  (terminal-variables (t1 (v1 voltage)
			  (i  current display))
		      (t2 (v2 voltage)
			  (i2 current)))
  (component-variables (v voltage display)
		       (c capacitance independent display)
		       (q charge display))
  (constraints ((ADD v v2 v1))			; Voltage measured across terminals
	       ((MULT v c q))			; Charge is product of Voltage and Capacitance
	       ((d/dt q i))			; Current is first derivative of Charge
	       ((MINUS i i2) (minf inf) (0 0) (inf minf))     	; Current at termainls has opposite sign
	       )
  )

;;; Resistor
(define-component
  resistor
  (terminal-variables (t1 (v1 voltage)
			  (i  current display))
		      (t2 (v2 voltage)
			  (i2 current)))
  (component-variables (v voltage display)
		       (r resistance independent display))
  (constraints ((ADD v v2 v1))			; Voltage measured across terminals
	       ((MULT i r v))			; Ohm's Law
	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	        ; Current at terminals has opposite sign
	       )
  )


;;; Inductor
(define-component
  INDUCTOR-A
  (terminal-variables (t1 (v1 voltage)
			  (i  current display))
		      (t2 (v2 voltage)
			  (i2 current)))
  (component-variables (v voltage display)
		       (l inductance independent display)
		       (neg-l inductance)
		       (fl flux-linkage display))
  (constraints ((ADD v v2 v1))			; Voltage measured across terminals
	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	; Current at terminals have opposite sign
	       ((MINUS l neg-l) (minf inf) (0 0) (inf minf))	; Negative inductance
	       ((d/dt fl v))			; Change in Flux-linkage = Voltage
	       ((MULT neg-l i fl))		; Inductor behavior
	       )
  )

(define-component
  INDUCTOR-B
  (terminal-variables (t1 (v1 voltage)
			  (i  current display))
		      (t2 (v2 voltage)
			  (i2 current)))
  (component-variables (v voltage display)
		       (l inductance independent display)
		       (neg-l inductance)
		       (di current display))
  (constraints ((ADD v v2 v1))			; Voltage measured across terminals
	       ((MINUS i i2) (minf inf) (0 0) (inf minf))	; Current at terminals have opposite sign
	       ((MINUS l neg-l) (minf inf) (0 0) (inf minf))	; Negative inductance
	       ((d/dt i di))			; Change in current
	       ((MULT neg-l di v))		; Inductor behavior
	       )
  )



;;; Tank
(define-component
  TANK
  (terminal-variables (in (inflow flow display))
		      (out (outflow flow display)
			   (outflow-pressure pressure display)))
  (component-variables (netflow flow display)
		       (amount amount display)
		       (level amount display))
  (constraints ((M+ amount level) (0 0) (inf inf))
	       ((M+ level outflow-pressure) (0 0) (inf inf))
	       ((M- outflow-pressure outflow) (minf inf) (0 0) (inf minf))
	       ((ADD inflow outflow netflow) (0 0 0))
	       ((d/dt amount netflow))
	       )
  )

(define-component
  SOURCE
  (terminal-variables (out (flow flow independent display)
			   (pressure pressure)))
  (constraints ((M- flow pressure) (0 0) (minf inf)))
  )

(define-component
  SINK
  (terminal-variables (in (flow flow display))))

