;;; -*- Syntax: Common-Lisp; Package: QSIM -*-
(in-package :qsim)
;;; Copyright (c) 1991, Benjamin Kuipers.

;;;
;;;      Two-compartment cascade:  ->[]->[]->
;;;

(define-component Cascade hydraulic "Two-compartment cascade"
  (components (f01 QPump)
	      (C0  source)
	      (C1  compartment)
	      (C2  compartment)
	      (C3  sink)
	      (f12 arrow)
	      (f23 arrow))
  (connections (n0 (C0 out)  (f01 in))
	       (n1 (f01 out) (C1 in))
	       (n2 (C1 out)  (f12 in))
	       (n3 (f12 out) (C2 in))
	       (n4 (C2 out)  (f23 in))
	       (n5 (f23 out) (C3 in))
	       ))



(defun test-cascade ()
  (setq qde (build-qde 'cascade))
  (let* ((sim  (make-sim :HOD-constraints t))
	 (init (make-CC-state  :from-qde qde
			       :sim sim
			       :assert-values '(((C1 amount)  (0 nil))
						((C2 amount)  (0 nil))
						((F01 Q)      ((0 inf) std))
						((F12 K)      ((0 inf) std))
						((F23 K)      ((0 inf) std))
						)
			       :text "Fill an empty cascade"))
	 (cc-layout '(( (n2 effort)  (n4 effort)  nil)
		      ( (F01 Q)      (F12 K)      (f23 K))
		      nil
		      nil)))
    (qsim init)			
    (CC-display init :layout CC-layout) ))

; Works correctly.
