;;; -*- Mode:Common-Lisp; Package:QSIM; Syntax:COMMON-LISP; Base:10 -*-

;;;  $Id: acc-three-tank.lisp,v 1.3 1991/09/16 14:11:10 clancy Exp $
(in-package :qsim)
; 1. Three-tank without curvature constraints.
; 2. Three-tank with automatic calculation of curvature constraints. 
; 3. Three-tank with automatic calculation of curvataure constraints and sd3-constraints. 

; 1. The three tank model: without curvature constraints. 

(define-QDE three-tank
  (text "Three-tank system")
  (quantity-spaces
    (amounta     (0 inf)       "amount (A)")
    (amountb     (0 inf)       "amount (B)")
    (amountc     (0 inf)       "amount (C)")
    (pressurea   (0 inf)       "pressure (A)")
    (pressureb   (0 inf)       "pressure (B)")
    (pressurec   (0 inf)       "pressure (C)")
    (delta-ab    (minf 0 inf)  "d press(A-B)")
    (delta-bc    (minf 0 inf)  "d press(B-C)")
    (inflowa     (0 inf)       "flow ( -> A)")
    (crossflowab (minf 0 inf)  "crossflow A -> B")
    (crossflowbc (minf 0 inf)  "crossflow B -> C")
    (outflowc    (0 inf)       "flow (C->out)")
    (netflowa    (minf 0 inf)  "d amount (A)")
    (netflowb    (minf 0 inf)  "d amount (B)")
    (netflowc    (minf 0 inf)  "d amount (C)"))
  (constraints
    ((M+ pressurea amounta)       (0 0) (inf inf))
    ((M+ pressureb amountb)       (0 0) (inf inf))
    ((M+ pressurec amountc)       (0 0) (inf inf))
    ((add delta-ab pressureb pressurea))
    ((add delta-bc pressurec pressureb))
    ((m+ crossflowab delta-ab)    (0 0) (inf inf))
    ((m+ crossflowbc delta-bc)    (0 0) (inf inf))
    ((m+ pressurec outflowc)      (0 0) (inf inf))
    ((add netflowa crossflowab inflowa))
    ((add netflowb crossflowbc crossflowab))
    ((add netflowc outflowc crossflowbc))
    ((d/dt amounta netflowa))
    ((d/dt amountb netflowb))
    ((d/dt amountc netflowc))
    ((constant inflowa)))
  (layout
    (amounta amountb amountc)
    (nil delta-ab delta-bc)
    (crossflowab crossflowbc outflowc)
    (netflowa netflowb netflowc)))

; 1b. Fill the three tank system, i.e. fill-three-tanks-from empty.
; 2. The three tank model: automatic determination of curvature constraints. A. C. C.
; 3. The three tank model: automatic determination of curvature constraints. A. C. C. 
;    and sd3-constraints. 
;	 (sd3-constraint ((netflowc (add (sd1 netflowa)(minus (sd1 netflowb))))
;			  (netflowb (minus (add (sd1 netflowa) (sd1 netflowc))))
;			  (netflowa (add (sd1 netflowc)(minus (sd1 netflowb))))))

(defun fill-three-tanks-from-empty (acc sd3)
  (setf (qde-derived-sd2-expressions three-tank) nil)
  (let* ((sim (make-sim :HOD-constraints acc
			:SD3-constraints sd3
			:analytic-functions-only t))
	 (init (make-new-state :from-qde three-tank
			       :assert-values '((amounta (0 nil))
						(amountb (0 nil))
						(amountc (0 nil))
						(inflowa ((0 inf) std)))
			       :sim sim)))
	 
    (format *QSIM-trace*
	    "~2% HOD constraints help on the Three-Tank model, but not very much.~%")

    (qsim init)
    (qsim-display init)))



