/*
 *  CQ -- "Waltz" performs Waltz filtering on tuples.  All tuples filtered
 *        out here are marked 'bad'.
 */

#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"


waltz()
{
    register struct tuple       *tupp;
    register struct constraint  *conp;
    register int  k;

    int   i, j, ntupok;


    /*  Loop over all constraints  */
    for (i = 0;  i < nconstraints;  i++)
    {
	conp = &constraint[i];
	tupp = conp->tuplep;
	ntupok = 0;

#ifdef TRACE
	if (trace & TR_WALTZ)
	    prcon( conp );
#endif

	/*  Loop over all tuples for this constraint  */
	for (j = 0;  j < conp->ntuples;  j++, tupp++)
	{
#ifdef TRACE
	    if (trace & TR_WALTZ)
		prtuple( conp, tupp);
#endif
	    /*  Loop over the 2 or 3 arguments in this tuple  */
	    for (k = 0;  k < conp->nargs;  k++)
	    {
		/*  Waltz filtering is performed here by simply checking to
		 *  see if each possible value (pval) in this tuple is used 
		 *  at least once by each constraint using that parameter.
		 *  No searches or associative matchings are needed since the
		 *  necessary pointers and counters have been maintained for
		 *  just this moment!
		 */
#ifdef TRACE
		if (trace & TR_WALTZ)
		    printf(" [%d %d]",
			tupp->pvalp[k]->ncons, conp->paramp[k]->ncons);
#endif
		if (tupp->pvalp[k]->ncons != conp->paramp[k]->ncons)
		    goto out;
	    }
#ifdef TRACE
	    if (trace & TR_WALTZ)
		putchar('\n');
#endif
	    ntupok++;
	    continue;

out:	    tupp->bad = TRUE;
#ifdef TRACE
	    if (trace & TR_WALTZ)
		puts(" rejected");
#endif
	}
	/*  If no legal tuples for this constraint, return now.  */
	if (ntupok == 0)
	{
	    puts("All tuples Waltz-filtered-out for following constraint");
	    prcon(conp);
	    return(FALSE);
	}

    }
    return(TRUE);
}
