#include  <stdio.h>
#include  "defs.h"
#define   EXTERN  extern
#include  "global.h"


/*
 *  Generate all tuples consistent with each constraint.
 */
gentuples()
{
    register int  i, r;
    register struct constraint *conp;
    register struct scorr      *scorrp;

    tup    = &tuple[0];
    if (curstatep)
	scorrp = curstatep->scorrp;

    /*  Loop over each constraint  */
    for (i = 0;  i < nconstraints;  i++, scorrp++)
    {
	conp = &constraint[i];

	/*  If this is an initial state (ala make-initial-state or 
	 *  make-modified-state), then use the initial correspondences that
	 *  already exist in 'constraint'.
	 *  If this is not an initial state (curstatep != 0) then install the
	 *  the set of corresponding values that exist in current state.
	 */
	if (curstatep)
	{
	    /*  This isn't the initial state, so use state correspondences */
	    conp->ncorrs = scorrp->ncorrs;
	    conp->corrp  = scorrp->corrp;
	}

	/*  Call the constraint check function for this constraint  */
	r = (*conp->funcp)(conp);

	if (tup > tupmax)
	{   printf("Exceeded limit of %d tuples\n", MAXTUPLES);
	    exit(1);
	}

	if (r == FALSE)
	{
	    puts("No valid tuples exist for following constraint:");
	    prcon(conp);
	    return(FALSE);
	}
    }

    if (tup > tuphigh)  tuphigh = tup;
    return(TRUE);
}
