/*
 *  This file contains functions for adding and removing items on the agenda.
 *  The agenda is a FIFO queue (represented as a circular list) in which each
 *  element is a pointer to a state awaiting prediction.  As simulation
 *  proceeds, state pointers are added to the tail of the agenda and removed
 *  from the head.
 */

#include  <stdio.h>
#include  "defs.h"


static struct state *agenda[MAXAGENDA];

static int      headx = 0, tailx = 0;
static Boolean  empty = TRUE;


addagenda( statep )
struct state  *statep;
{
    if (headx == tailx)
    {
	if (empty)
	    empty = FALSE;
	else
	{
	    puts("Agenda exceeded, discarding state.\n");
	    return;
	}
    }

    agenda[tailx++] = statep;

    /*  Wrap-around if tailx at end of array.  */
    if (tailx >= MAXAGENDA)
	tailx = 0;
}


struct state *
remagenda()
{
    register struct state  *statep;

    if (empty)  return((struct state *) 0);

    statep = agenda[headx++];

    /*  Wrap-around if headx at end of array.  */
    if (headx >= MAXAGENDA)
	headx = 0;

    /*  If head has caught up to tail, then agenda is empty.  */
    if (headx == tailx)
	empty = TRUE;

    return(statep);
}
