;;; -*- Mode:Common-Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-

;;; Copyright (c) 1990 by James Crawford.
;;;  $Id: acommon.lisp,v 1.1 92/04/16 09:29:52 clancy Exp $

;;;                        ****** ACOMMON ******

;;; Common lisp versions of device dependent routines.
;;; Generally these routines stub out functionality not supported in common lisp.

(defun clear-window ()
  (format t "~& Don't know how to clear window on this system.~%"))

;;; Dot tracing.  In common lisp we can output trace but it is not mouse sensitive:


(defparameter *dot-count* 0)
(defparameter *dot-limit* 100)
(defvar *dot-output* *standard-output*)

(defparameter *dot-trace-present* t)

(defun dot-present (symbol text)
  (declare (ignore text))
  (when *dot-trace-present* 
    (princ symbol *dot-output*)
    (dot-count)))

(defun dot-count ()
  (incf *dot-count*)
  (when (> *dot-count* *dot-limit*)
    (terpri *dot-output*)
    (princ "  ")
    (setq *dot-count* 2)))

(defun dot-terpri ()
  (terpri *dot-output*)
  (setq *dot-count* 0))

(defun reset-presenter ()
  (setq *dot-count* 0))

(defun view-dot-trace ()
  (format t "~& Can't view dot trace on your machine."))


;;; Utilities for overviewing the knowledge-base.

(defparameter *relations* nil)
(defparameter *collected-relations* nil)


(defun kb-overview (&key (relation 'subset) (root 'things) (stream t) depth border (rtl t) (rl nil))
  (declare (ignore rtl))
  (declare (ignore border))
  (declare (ignore depth))
  (declare (ignore root))

  (setq *relations* (if (consp relation) relation (list relation)))
  (collect-relations)
  (if rl
      (setq *collected-relations*
	    (mapcar #'(lambda (rel) `((inverse ,(first rel)) ,(third rel) ,(second rel)))
		    *collected-relations*)))
  (terpri stream) (terpri stream)
  (format stream "Showing relations: ")
  (dolist (relation *relations*) (format stream " ~@(~a~)" relation))
  (format stream ".~%")
  ;; In common lisp all we can do is list them:
  ;; (Should take out relations to frames not reachable from root.)
  (pp-labeled-list 2 "Relations:" *collected-relations* nil))

(defun collect-relations ()
  (setq *collected-relations* nil)
  (flet ((my-push (item)
	   (push item *collected-relations*)))
    (dolist (relation *relations*)
      (with-no-output (dolist (f (all-frames))
			(a-query nil `((:retrieve (,relation (:quote ,f) ?x))
				       (:apply ,#'my-push ((,relation ,f ?x))))))))))


;; Then the code to collect the sets in the kb and show their members:

;;; This last function no current used (but might be useful in the future).
;;;
(defun show-sets ()
  (setq *relations* '(isa))
  (collect-relations)
  (let ((sets nil))
    (dolist (rel *collected-relations*)
      (if (not (end-search (string 'selfset) (string (second rel))))
	  (pushnew (second rel) sets)))
    ;; Explicitly take things out:
    (setq sets (delete 'things sets))
    (dolist (set (sort sets #'alphalessp))
      (pp-labeled-list 2
		       (format nil "~@(~a~):" set)
		       (sort (mapcan #'(lambda (rel)
					 (if (eql set (second rel))
					     (list (first rel))))
				     *collected-relations*)
			     #'alphalessp)
		       nil))))


(defun end-search (x y)
  (if (not (< (length y) (length x)))
      (string-equal x y :start2 (- (length y) (length x)))))
