
(defun facts-about-steril ()
  (facts-about-representatives)
  (a-assert "Taxonomy"
            '((:taxonomy (physical-objects (bacteria) (containers)))))
  (a-assert "Slots"
            '((:slot in (physical-objects containers)
                     :comment "(in ?po ?c) = ?po is in the container ?c.")
              (:slot bacteria-in (containers sets)
                     :comment "(bacteria-in ?c ?s) = The set of bacteria in ?c is ?s.")
              (:slot temperature (physical-objects nil)
                     :cardinality 1)
              (:slot steril (containers booleans)
                     :comment "(steril ?c true) = ?c is steril.")
              (:slot sealed (containers booleans)
                     :comment "(sealed ?c true) = ?c is sealed.")
              (:slot dead (physical-objects booleans)
                     :comment "(dead ?x true) = ?x is dead.")))
  (a-assert "Rules"
            '((:rules containers
                      ;; This rule is really a type restriction on the slot
                      ;; bacteria-in -- the set of bacteria in a container
                      ;; must be a subset of the set of all bacteria:
                      ((bacteria-in ?c ?s) -> (imp-superset ?s bacteria))
                      ;; Any member of the set of bacteria in a container must be
                      ;; in the container:
                      ((bacteria-in ?c ?s) (member ?s ?b) -> (in ?b ?c))
                      ;; We are willing to create a frame for the set of bacteria in
                      ;; a container if we need one:
                      ((bacteria-in ?c ?s) <- (:forc ?s (bacteria-in ?c ?s)))
                      ;; A container is steril if its sealed and all the bacteria in it are dead:
                      ((steril ?c true)
                       <-
                       (sealed ?c true)
                       (bacteria-in ?c ?bac)
                       (:in-own-partition (representative ?bac ?r))
                       (dead ?r true)))
              (:rules physical-objects
                      ;; Physical objects inherit the temperature of their container:
                      ((temperature ?po ?t) <- (in ?po ?c) (temperature ?c ?t)))
              (:rules bacteria
                      ;; How to kill a bacteria:
                      ((dead ?b true) <- (temperature ?b ?t) (:test (>= ?t 212)))))))


(defun queries-about-steril ()
  (a-assert "Facts"
            '(;;A sealed container is heated to 212 degrees:
              (:create ?c can)
              (sealed ?c true)
              (temperature ?c 212)))
  (a-query "Is the container steril ?"
           '((steril can true))))


(defun facts-about-representatives ()
  (a-assert "Taxonomy"
            '((:taxonomy (objects (representatives)))))
  (a-assert "Slots"
            '((:slot representative (sets representatives)
                     :partition set-partition
                     :comment "(representative ?s ?r) = The representative of set ?s is ?r.")))
  (a-assert "Rules"
            '((:rules sets
                      ;; Every set has a representative:
                      ((representative ?s ?r) <- (:forc ?r (representative ?s ?r)))
                      ;; Every representative is a member of the set:
                      ((representative ?s ?r) -> (member ?s ?r))))))
