
;;; Find n hosts connected to at least m file-servers.
;;;
(defparameter hosts nil)

(defun find-hosts (n m)
  (setq hosts nil)
  (catch 'done
    (silently (a-query nil `(;; For all hosts
                             (member hosts ?h)
                             ;; Set ?m to number of file-servers:
                             (:bind-to-values ?fs ?h connected-to) (:bind ?m (length '?fs))
                             (:test (>= ?m ,m))
                             ;; Push onto hosts and see if we are done:
                             (:lisp (progn (push '?h hosts)
                                           (if (eql (length hosts) ,n) (throw 'done hosts)))))))))

;;; Sample knowledge-base to test find-hosts.
;;;
(defun facts-about-hosts ()
  (a-assert "Taxonomy"
            '((:taxonomy (objects (hosts host1 host2 host3 host4 host5)
                                  (file-servers fs1 fs2 fs3 fs4 fs5)))))
  (a-assert "One new slot"
            '((:slot connected-to (hosts file-servers))))

  (a-assert "Some connections"
            '((connected-to host1 fs1)
              (connected-to host2 fs1)
              (connected-to host3 fs1)
              (connected-to host4 fs1)
              (connected-to host5 fs1)

              (connected-to host1 fs2)
              (connected-to host2 fs2)
              (connected-to host3 fs2)
              (connected-to host4 fs2)

              (connected-to host1 fs3)
              (connected-to host2 fs3)
              (connected-to host3 fs3)

              (connected-to host1 fs4)
              (connected-to host2 fs4)

              (connected-to host1 fs5))))

(defun queries-about-hosts ()
  (a-assert "Make a set of hosts"
            '((:bind ?n (progn (format t "~% Number of hosts: ")
                               (read)))
              (:bind ?m (progn (format t "~% Number of servers: ")
                               (read)))

              (:create ?new-set)
              (:lisp (format t "~%~% Created new set ~a.~%" '?new-set))
              (imp-superset ?new-set hosts)

              (:branch-on-values ?x (find-hosts '?n '?m))
              (member ?new-set ?x))))



