;;;   -*- Syntax: Common-Lisp; Package: USER; Base: 10; Mode: LISP -*-    ;;;
;;;                                                                       ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;                        ****** BLOCKS ******
;;;
;;; This example illustrates the use of "ask slots" and the implementation of a counter in
;;; Algernon (see manual sections 4.5.3 and 4.6.3).


(defun facts-about-blocks ()
  (a-assert "Extentions to taxonomy."
	    '((:taxonomy (objects (counters counter)
				  (blocks block1 block2 block3)))
	      (:taxonomy (colors (block-colors blue red purple)))
	      (:taxonomy (slots (ask-slots)))))

  (a-assert "New slots."
	    '((:slot increment (counters booleans)
		     :comment "For a counter x, asserting (increment x true) increments the count by one.")
	      (:slot current-count (counters nil))
	      (:slot block-color (blocks block-colors))))

  (a-assert "Incrementing counters."
	    ;; Carefully crafted rule to increment counter -- see manual section 4.6.3.
	    '((:rules counters
	       ((increment ?c true)
		->
		(current-count ?c ?n)
		(:clear-slot ?c current-count)
		(:clear-slot ?c increment)
		(:bind ?m (+ ?n 1))
		(current-count ?c ?m)))))
  
  (a-assert "Ask slots"
	    ;; See manual section 4.5.3 (under :ask).
	    '((:srules ask-slots
	       ((?r ?x ?y) <- (:ask (?r ?x ?y))))))

  (a-assert "block-color is an ask slot"
	    '((isa (:slot block-color) ask-slots)))
  
  (a-assert "Count the blue blocks"
	    '((:rules blocks
	       ((block-color ?b blue) -> (increment counter true))))))

(defun queries-about-blocks ()
  (a-assert "Reset counter."
	    '((current-count counter 0)))
  (a-query "What colors are the blocks?"
	   '((member blocks ?m)
	     (block-color ?m ?mc)))
  (a-query "How many blue blocks were there?"
	   '((current-count counter ?x))))