;;; -*- Mode:Common-Lisp; Package:USER; Syntax:COMMON-LISP; Base:10 -*-
;;; Copyright (c) 1990 by James Crawford.
(in-package 'user)
(provide 'algy)

;;; Modified by BJK (1-14-92) for the ES version.

;;;                        ****** ALGY ******

;;; Compiles and loads all files for Algernon and initializes.

;;; Should be updated to keep bin files in:
;;;  .../bin/<machine name>-<lisp name>/...

;;; Main Algernon directory in public (except for mac ...):
(defparameter @algy-path
	      #-(or UNIX :apple) "AI:/v/ai/v0/kuipers/es/algy/"
              #+UNIX "/v/ai/v0/kuipers/es/algy/"
	      #+:apple "hd:applications:Allegro CL:Algernon:"
	      "Path to main Algernon directory.")


;;; Then the other paths:
(defparameter @algy-source-path 
	      #-:apple (format nil "~(~a~)source/" @algy-path)
	      #+:apple (format nil "~(~a~)source:" @algy-path)
	      "Path to source files")
(defparameter @algy-help-path
	      #-:apple (format nil "~(~a~)help/" @algy-path)
	      #+:apple (format nil "~(~a~)help:" @algy-path))
(defparameter @algy-example-path
	      #-:apple (format nil "~(~a~)examples/" @algy-path)
	      #+:apple (format nil "~(~a~)examples:" @algy-path))
;;; Object files are usually stored on each machine:
(defparameter @algy-object-path
	      #+(and AKCL SUN) "/v/ai/v0/kuipers/es/algy/akcl-sun/"
              #+(and :lcl3.0 (not :lcl4.0)) "/v/ai/v0/kuipers/es/algy/lucid-sun/"
              #+:lcl4.0 "/v/ai/v0/kuipers/es/algy/sun4_4.0/"
	      #+(and AKCL HP) "/v/ai/v0/kuipers/es/algy/akcl-hp/"
              #+(and :LUCID :HP) "/v/ai/v0/kuipers/es/algy/lucid-hp/"
	      #+EXPLORER "Wichita:algernon;"
	      #+SYMBOLICS "PEANO:>algy>"
	      #+:apple "hd:applications:Allegro CL:Algernon:object:"
	      "Path to object files.")

;;; And the suffixies for various kinds of files:
(defparameter @lisp-file-extension ".lisp")
(defparameter @algy-help-suffix ".txt")
(defparameter @obj-file-extension
  #+AKCL ".o"
  #+(and :LUCID :SPARC :SUN) ".sbin"
  #+(and :LUCID :MC68000 :SUN) ".lbin"
  #+(and :LUCID :HP) ".b"
  #+SYMBOLICS ".bin"
  #+EXPLORER ".xld"
  #+:apple ".fasl")
(defparameter @kb-file-extension ".kb"
	      "The file name extension used by Algernon to store knowledge-bases.")


;;; The "path terminator" is used only in querying the user for their kb directory:
(defparameter @path-terminator 
  #+UNIX "/"
  #+SYMBOLICS ">"
  #+EXPLORER ";"
  #+:apple ":")

(defparameter *sys-print-structure-var*
	      #+symbolics '*print-structure-contents*
	      #-symbolics  '*print-structure*
	      "Cltl does not provide a variable to force structures to be printed out readably.~@
               Fortunately, most CL implementations do, but the variable name is not standardized.~@
               Used in write-kb for aresults.")


;;; Then the files for Algernon:
(defparameter *algy-files*
  
  '("aframes"
    "amatch"
    "asyntax"
    
    "atrace"
    "adepnet"
    "acontra"
    "apart"
    "aassump"
    "anames"
    "acount"
    
    "arules"
    "aidg"
    "alogic"
    
    "adump"
    "aprep"
    "app"
    
    "aface"
    "akbase"))

;;; Load device dependent routines:
;;; (if you write your own versions of these routines you should push the name
;;; of your source file onto *algy-files* here)
#+SYMBOLICS (pushnew "asymbolics" *algy-files*)
#+:apple (pushnew "amac" *algy-files*)
#+:apple (pushnew "agraph" *algy-files*)
;;; acommon contains common lisp functions "stubbing out" the fancy graphics:
#-(or SYMBOLICS :apple) (pushnew "acommon" *algy-files*)


;;; But before anything else load aglobals:
(push "aglobals" *algy-files*)


;;; Finally, the name of the files holding the code for the background knowledge-base
;;; and the stored background knowledge-base.
(defparameter @algy-kb-path
	      @algy-source-path
  "The directory in which Algernon looks for the background knowledge-base.")
;;; This parameter should be changed to load a different basic kb:
(defparameter @kb-name "akbase")
;;; Name of file initial kb is stored into (in the object directory):
(defparameter @stored-kb-name "initial")

;;; Override some strange defaults (especially under AKCL):
;;(proclaim '(optimize (safety 2) (speed 2) (space 2)))
;;(proclaim '(optimize (safety 0) (speed 3) (space 0)))

;;; One last global:
(defvar *load-times* nil "Assoc list of files and when they were loaded.")

;; Print out changes file (if any).
(setq *changes-path* (concatenate 'string @algy-path "recent.changes"))
(if (probe-file *changes-path*)
    (with-open-file (changes-file *changes-path*)
      (format t "~%")
      (loop (let ((inline (read-line changes-file nil 'eof)))
	      (if (eql inline 'eof)
		  (return)
		  (write-line inline))))
      (format t "~%")))

;;; First, a bootstrap load of aload_aux.l

(if (assoc "aload_aux" *load-times* :test #'equal) 		 	        ; If aload_aux.l is loaded
    (algy-compile-load "aload_aux")     					        ; then just use algy-compile-load
                                                                                ; otherwise its more complex ...
    (let ((lisp-file (concatenate 'string @algy-source-path "aload_aux" @lisp-file-extension))
	  (binary-file (concatenate 'string @algy-object-path "aload_aux" @obj-file-extension)))
      (cond ((probe-file lisp-file)
	     (cond ((probe-file binary-file)
	            (let ((lisp-date   (file-write-date lisp-file))
		          (binary-date (file-write-date binary-file)))
		      (if (> lisp-date binary-date)
		          (compile-file lisp-file :output-file binary-file))
	              (load binary-file)
		      (update-load-times "aload_aux")))
		   (t
		    (compile-file lisp-file :output-file binary-file)
		    (load binary-file)
		    (update-load-times "aload_aux"))))
	    (t
	     (format t "No file ~(~a~)." lisp-file)))))


;;; Then load the rest.

(load-algy)

;;; Leave it to user to run algy:
#-symbolics (format t "~&~% To run Algernon type: (algy).")

#+symbolics (cp:define-command (com-algy :command-table "user") ()
	       (algy))
#+symbolics (format t "~&~% To run Algernon type: Algy.")
