/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

system(ProgramName, Arguments, Status) :-
    '$map_to_atom'(ProgramName, ProgramNameAtom),
    '$map_to_atoms'(Arguments, ArgumentsAtom),
    '$system'(ProgramNameAtom, ArgumentsAtom, Status).

system(Command, Status) :-
    '$parse_command'(Command, ProgramName, Arguments),
    '$system'(ProgramName, Arguments, Status).

system(Command) :-
    system(Command, _Status).

/*----------------------------------------------------------------------------
'$parse_command'(Command, ProgramName, Arguments) :-
    parse the string (or atom ) in Command into a ProgramName (the first
    token) and a list of arguments (the rest of the tokens where space
    delimits tokens).  Following the convention the ProgramName appears
    as the first argument in its call.
----------------------------------------------------------------------------*/
'$parse_command'(Command, ProgramName, [ProgramName|Arguments]) :-
    once((name(Command, CommandString); CommandString = Command)),
    '$parse_command_term'(CommandString, ProgramName, ArgumentString),
    '$parse_arguments'(ArgumentString, Arguments).

'$parse_arguments'([], []).
'$parse_arguments'(ArgumentString, [Argument|Arguments]) :-
    '$parse_command_term'(ArgumentString, Argument, RestString),
    '$parse_arguments'(RestString, Arguments).


/*----------------------------------------------------------------------------
'$parse_command_term'(String, FrontAtom, RestString) :-
    True, iff String contains a token FrontAtom delimited by a space,
    returning RestString.
----------------------------------------------------------------------------*/
'$parse_command_term'(String, FrontAtom, RestString) :-
    once(((append(FrontString, Back, String),
	  ((Back = [], RestString = []); Back = [0' |RestString]), % space
	  FrontString \== []))),
    name(FrontAtom, FrontString).

/*----------------------------------------------------------------------------
'$map_to_atoms'(Terms, Atoms) :-
    True, iff Terms is a list whose members are either atoms or strings or 
    integers and Atoms are there atom counterparts.
----------------------------------------------------------------------------*/
'$map_to_atoms'([], []).
'$map_to_atoms'([Term|Terms], [Atom|Atoms]) :-
    '$map_to_atom'(Term, Atom),
    '$map_to_atoms'(Terms, Atoms).

'$map_to_atom'(Term, Term) :-
    atom(Term), !.
'$map_to_atom'(String, Atom) :-
    name(Atom, String), !.
'$map_to_atom'(Integer, Atom) :-
    number_chars(Integer, String),
    atom_chars(Atom, String).
    
csh :- 
    system("/bin/csh").

sh :- 
    system("/bin/sh").

fork :-
    '$fork'.

fork(Pid, Read, Write) :-
    '$fork3'(Pid, Read, Write).
