/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

freeze(Term) :-
    '$collect_variables'(Term, var, [], Vars),
    '$freeze2'(Vars).

'$freeze2'([]).
'$freeze2'([X|Vars]) :-
    '$freeze'(X),
    '$freeze2'(Vars).

thaw(Term) :-
    \+ '$check_delayed_problem'('='),
    '$collect_variables'(Term, var, [], Vars),
    '$thaw2'(Vars).

'$thaw2'([]).
'$thaw2'([X|Vars]) :-
    '$thaw'(X),
    '$thaw2'(Vars).

frozen(Term) :-
    '$collect_variables'(Term, var, [], Vars),
    '$frozen2'(Vars).

'$frozen2'([]).
'$frozen2'([X|Vars]) :-
    '$frozen'(X),
    '$frozen2'(Vars).

'$collect_variables'(Term, Type, VariablesIn, VariablesOut) :-
    setFlag(localfix, on, Old),
    '$collect_vars'(Term, Type, VariablesIn, VariablesOut),
    setFlag(localfix, Old, _).

'$collect_vars'(Term, Type, VariablesIn, VariablesOut) :-
    substitute(Term, Subs, T),
    '$collect_subs'(Subs, Type, VariablesIn, Variables1),
    '$collect_var'(T, Type, Variables1, VariablesOut).

'$collect_var'(Term, Type, VariablesIn, VariablesOut) :-
    '$var_type'(Type1, Term), !,
    ('$is_var_type'(Type, Type1) ->
	'$add_to_vars'(Term, VariablesIn, VariablesOut)
    ;
	VariablesOut = VariablesIn
    ).
'$collect_var'(Term, Type, VariablesIn, VariablesOut) :-
    once((
    (atomic(Term), Args = [])
    ;
    Term =.. Args
    ;
    (quantify(Term, _, X, T1),
     Args = [X, T1])
    )),
    '$collect_vars_in_args'(Args, Type, VariablesIn, VariablesOut).

'$collect_subs'([], _, VariablesIn, VariablesIn).
'$collect_subs'([Sub|Subs], Type, VariablesIn, VariablesOut) :-
    '$collect_sub'(Sub, Type, VariablesIn, Variables1),
    '$collect_subs'(Subs, Type, Variables1, VariablesOut).

'$collect_sub'([], _, VariablesIn, VariablesIn).
'$collect_sub'([T/X|Sub], Type, VariablesIn, VariablesOut) :-
    '$collect_vars'(X, Type, VariablesIn, Variables1),
    '$collect_vars'(T, Type, Variables1, Variables2),
    '$collect_sub'(Sub, Type, Variables2, VariablesOut).

'$collect_vars_in_args'([], _, VariablesIn, VariablesIn).
'$collect_vars_in_args'([Term|Terms], Type, VariablesIn, VariablesOut) :-
    '$collect_vars'(Term, Type, VariablesIn, VariablesTmp),
    '$collect_vars_in_args'(Terms, Type, VariablesTmp, VariablesOut).

'$var_type'(meta_var, Term) :- var(Term), !.
'$var_type'(local_object_var, Term) :- '$is_local_object_var'(Term), !.
'$var_type'(dynamic_object_var, Term) :- is_object_var(Term), !.

'$is_var_type'(Type, Type) :- !.
'$is_var_type'(object_var, dynamic_object_var) :- !.
'$is_var_type'(var, Type) :- Type \== local_object_var, !.
