/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

/*----------------------------------------------------------------------------
dynamic(Predicate) :-
    
----------------------------------------------------------------------------*/
dynamic([]).
dynamic([Pred|Predicates]) :- dynamic(Pred), dynamic(Predicates).
dynamic(F/N) :-
    (\+ '$dynamic'(F/N) 
	-> '$trap_colon'((['$dynamic',F]:[N]), NewHead),
	   '$assertz'(NewHead)
    ;
	   true
    ),
    abolish(F, N).

'$dynamic'(F/N) :-
    clause((['$dynamic', F]:[N]), _).

assert(Clause) :-
    assertz(Clause).

asserta(Clause):-
    retry_delay_problems,
    \+ '$check_delayed_problem'('='),
    '$gather_delayed_goals'(Clause, NewClause),
    '$asserta2'(NewClause).

'$asserta2'((Head :- Body)):-
    !,
    '$trap_colon'(Head, NewHead),
    functor(NewHead, F, N),
    (\+ '$dynamic'(F/N) -> dynamic(F/N) ; true),
    '$asserta'((NewHead :- Body)).
'$asserta2'(Head):-
    '$trap_colon'(Head, NewHead),
    functor(NewHead, F, N),
    (\+ '$dynamic'(F/N) -> dynamic(F/N) ; true),
    '$asserta'(NewHead).

assertz(Clause):-
    retry_delay_problems,
    \+ '$check_delayed_problem'('='),
    '$gather_delayed_goals'(Clause, NewClause),
    '$assertz2'(NewClause).

'$assertz2'((Head :- Body)):-
    !,
    '$trap_colon'(Head, NewHead),
    functor(NewHead, F, N),
    (\+ '$dynamic'(F/N) -> dynamic(F/N) ; true),
    '$assertz'((NewHead :- Body)).
'$assertz2'(Head):-
    '$trap_colon'(Head, NewHead),
    functor(NewHead, F, N),
    (\+ '$dynamic'(F/N) -> dynamic(F/N) ; true),
    '$assertz'(NewHead).

'$trap_colon'((Atoms : Arg), NewHead) :-
    '$atoms_to_atom'(Atoms, Atom), !,
    NewHead =.. [Atom, Arg].
'$trap_colon'(Head, Head).

'$gather_delayed_goals'(Clause, NewClause) :-
    get_not_free_goals(Clause, NotFreeList),
    setFlag(localfix, on, Old),
    '$rhs_list'(NotFreeGoals, NotFreeList),
    '$insert_goals'(Clause, NotFreeGoals, NewClause),
    setFlag(localfix, Old, _).

get_not_free_goals(Term, NotFreeGoals) :-
    '$collect_variables'(Term, meta_var, [], MetaVars),
    '$collect_variables'(Term, dynamic_object_var, [], ObjVars),
    setFlag(localfix, on, Old),
    '$generate_not_free_goals'(ObjVars, MetaVars, NFIGoals),
    '$simplify'(NFIGoals, Simplified),
    '$replace_local'(Simplified, NotFreeGoals),
    setFlag(localfix, Old, _).

'$replace_local'(TermWithLocals, TermWithoutLocals) :-
    substitute(TermWithLocals, SubsIn, TermIn),
    '$replace_local_in_subs'(SubsIn, SubsOut),
    '$replace_local_in_term'(TermIn, TermOut),
    substitute(TermWithoutLocals, SubsOut, TermOut).

'$replace_local_in_subs'([], []).
'$replace_local_in_subs'([SIn|SubsIn], [SOut|SubsOut]) :-
    '$replace_local_in_sub'(SIn, SOut),
    '$replace_local_in_subs'(SubsIn, SubsOut).

'$replace_local_in_sub'([], []).
'$replace_local_in_sub'([TermIn/X|SubsIn], [TermOut/X|SubsOut]) :-
    '$replace_local'(TermIn, TermOut),
    '$replace_local_in_sub'(SubsIn, SubsOut).

'$replace_local_in_term'(X, '$') :-
    '$is_local_object_var'(X), !.
'$replace_local_in_term'(X, X) :-
    (	atomic(X)
    ;
    	var(X)
    ;
    	is_object_var(X)
    ), !.
'$replace_local_in_term'(TermIn, TermOut) :-
    quantify(TermIn, Q, X, BodyIn),
    '$replace_local'(BodyIn, BodyOut),
    quantify(TermOut, Q, X, BodyOut).
'$replace_local_in_term'(TermIn, TermOut) :-
    functor(TermIn, F, N),
    functor(TermOut, F, N),
    '$replace_local_in_args'(N, TermIn, TermOut).

'$replace_local_in_args'(0, _, _).
'$replace_local_in_args'(N, TermIn, TermOut) :-
    arg(N, TermIn, ArgIn),
    arg(N, TermOut, ArgOut),
    '$replace_local'(ArgIn, ArgOut),
    N1 is N - 1,
    '$replace_local_in_args'(N1, TermIn, TermOut).

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
retract((Head :- Body)) :-
    !,
    retry_delay_problems,
    \+ '$check_delayed_problem'('='),
    '$trap_colon'(Head, NewHead),
    functor(NewHead, Functor, Arity),
    '$retract_clause'(Functor, Arity, (NewHead :- Body)).
retract(Head) :-
    retry_delay_problems,
    \+ '$check_delayed_problem'('='),
    '$trap_colon'(Head, NewHead),
    functor(NewHead, Functor, Arity),
    '$retract_clause'(Functor, Arity, (NewHead :- _Body)).

'$retract_clause'(Functor, Arity, Clause) :-
    '$first_clause'(Functor, Arity, Ref),
    '$retract_ref'(Ref, Clause).

'$retract_ref'(Ref, Clause) :-
    ('$next_clause'(Ref, NextRef) ->
	(
	    '$instance'(Ref, Clause),
	    '$erase'(Ref)
	;
	    '$retract_ref'(NextRef, Clause)
	)
    ;
	'$instance'(Ref, Clause),
	'$erase'(Ref)
    ).

/*----------------------------------------------------------------------------
retractall(Functor, Arity) :-
----------------------------------------------------------------------------*/
retractall(Head) :-
    retract(Head),
    fail.
retractall(_).

abolish(Functor, Arity) :-
    retry_delay_problems,
    \+ '$check_delayed_problem'('='),
    once((\+ \+ ('$first_clause'(Functor, Arity, Ref),
	    '$retractall_ref'(Ref)) ; true)).

'$retractall_ref'(Ref) :-
    ('$next_clause'(Ref, NextRef) ->
	'$erase'(Ref),
	'$retractall_ref'(NextRef)
    ;
	'$erase'(Ref)
    ).

clause(Head, Body):-
    '$trap_colon'(Head, NewHead),
    functor(NewHead, Functor, Arity),
    '$first_clause'(Functor, Arity, Ref),
    '$clause_ref'(Ref, (NewHead :- Body)).

'$clause'(Functor, Arity, Head, Body):-
    '$first_clause'(Functor, Arity, Ref),
    '$clause_ref'(Ref, (Head :- Body)).

'$clause_ref'(Ref, Clause) :-
    '$last_clause'(Ref),
    !,
    '$instance'(Ref, Clause).
'$clause_ref'(Ref, Clause) :-
    '$instance'(Ref, Clause).
'$clause_ref'(Ref, Clause) :-
    '$next_clause'(Ref, NextRef),
    '$clause_ref'(NextRef, Clause).

/*----------------------------------------------------------------------------
----------------------------------------------------------------------------*/
listing(F/1) :-
    '$atoms_to_atom'(F, NewF),
    !,
    '$clause'(NewF, 1, Head, Body),
    arg(1, Head, Arg),
    (Body == true ->
	portray_clause(F : Arg)
    ;
	portray_clause((F : Arg :- Body))
    ),
    fail.
listing(F/N) :-
    '$clause'(F, N, Head, Body),
    (Body == true ->
	portray_clause(Head)
    ;
	portray_clause((Head :- Body))
    ),
    fail.

'$generate_not_free_goals'(ObjVars, MetaVars, NotFreeGoals) :-
    '$generate_not_free_goal'(ObjVars, ObjVars, MetaVars, NotFreeGoals-Goals1),
    '$generate_not_free_goal'(MetaVars, ObjVars, MetaVars, Goals1-[]).

'$generate_not_free_goal'([], _, _, L-L).
'$generate_not_free_goal'([X|Xs], ObjVars, MetaVars, Goal-Goals) :-
    '$first_not_free'(X, Ref),
    !,
    '$generate_not_free_goal2'(Ref, X, ObjVars, MetaVars, Goal-Goal1),
    '$generate_not_free_goal'(Xs, ObjVars, MetaVars, Goal1-Goals).
'$generate_not_free_goal'([_|Xs], ObjVars, MetaVars, Goal-Goals) :-
    '$generate_not_free_goal'(Xs, ObjVars, MetaVars, Goal-Goals).

'$generate_not_free_goal2'(Ref, X, ObjVars, MetaVars, Goal-Goal1) :-
    '$get_not_free'(Ref, Var, Term),
    (once(((var(Var), '$member2'(Var, MetaVars))
     	  ;
      	  (is_object_var(Var), '$member2'(Var, ObjVars))
     	 )) ->
	Goal = [Term|Goal2]
    ;
	Goal = Goal2
    ),
    '$generate_not_free_goal3'(Ref, X, ObjVars, MetaVars, Goal2-Goal1).

'$generate_not_free_goal3'(Ref, X, ObjVars, MetaVars, Goal) :-
    '$next_not_free'(Ref, NextRef),
    !,
    '$generate_not_free_goal2'(NextRef, X, ObjVars, MetaVars, Goal).
'$generate_not_free_goal3'(_, _, _, _, Goal-Goal).

'$rhs_list'(End, [End]) :- var(End), !.
'$rhs_list'(End, [End]) :- End \= (_ , _), !.
'$rhs_list'((Head, Tail), [Head|Tail2]) :-
    !,
    '$rhs_list'(Tail, Tail2).
'$rhs_list'(_, []).

'$insert_goals'(Clause, Goal, Clause) :- var(Goal), !.
'$insert_goals'((Head :- Body), Goal, (Head :- Goal, Body)) :- !.
'$insert_goals'(Head, Goal, (Head :- Goal)) :- !.
/*------------------------------------------------------------------------------
varsin(Term, VarList)

    Unify VarList with the list of variables in Term.

------------------------------------------------------------------------------*/
varsin(Term, VarList) :- 
    '$collect_variables'(Term, var, [], VarList).

