/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */


% Implementation of [File1, ..., Filen].
[].
[File|Files] :-
    consult(File),
    Files.

consult(FileName) :-
    '$parse_filename'(FileName, NewFileName, Type),
    % error('loading '), error(NewFileName), error(' ... '),
    flush(user_error),
    '$consult_type'(Type, NewFileName)
    % , errorln('loaded')
    .

'$consult_type'(source, FileName) :-
    '$consult_source'(FileName).
'$consult_type'(object, FileName) :-
    '$consult'(FileName),
    \+ \+ '$query'
    .

'$consult_source'(FileName) :-
    seeing(CurrentInput),
    (see(FileName) ->
	true
    ;
	% error( 'Error : file '),
	% error( FileName),
	% errorln( ' does not exist'),
	fail
    ),
    \+ \+ '$read_clauses',
    seen,
    see(CurrentInput).

'$read_clauses' :-
    repeat,
    read(Clause),
    (Clause \== end_of_file ->
	'$handle_clause'(Clause),
	fail
    ;
	true
    ), !.

'$handle_clause'((:-(Goal))) :-
    !,
    once((Goal ; true)).
'$handle_clause'((?-(Goal))) :-
    !,
    once((Goal ; true)).
'$handle_clause'(Clause) :-
    '$assertz2'(Clause).
	

/*----------------------------------------------------------------------------
'$parse_filename'(FileName, NewFileName, Type) :-
    True, iff FileName is an atom or string and 
    FileName is of type <prefix> or <prefix>.<extension> where valid
    extensions are qo or ql.
    If FileName is a prefix only then if the file <prefix>.qo exists then
    NewFileName is <prefix>.qo by default, otherwise is <prefix>.ql
    Type is source for <extension> = ql 
	    object 		     qo

----------------------------------------------------------------------------*/
'$parse_filename'(FileName, NewFileName, Type) :-
    name(FileName, FileNameString), !,
    '$parse_filename2'(FileNameString, NewFileName, Type).
'$parse_filename'(FileName, NewFileName, Type) :-
    '$parse_filename2'(FileName, NewFileName, Type).

'$parse_filename2'(FileNameString, NewFileName, Type) :-
    append(_Prefix, [0'., 0'q, OorL], FileNameString), !,
    '$type_file'(OorL, Type),
    name(NewFileName, FileNameString).
'$parse_filename2'(FileNameString, NewFileName, object) :-
    append(FileNameString, ".qo", NewFileNameString),
    append("test -f ", NewFileNameString, Command),
    % system(Command, 0), !,
    name(Cmd, Command),
    system('sh', ['sh', '-c', Cmd], 0), !,
    name(NewFileName, NewFileNameString).
'$parse_filename2'(FileNameString, NewFileName, source) :-
    append(FileNameString, ".ql", NewFileNameString),
    append("test -f ", NewFileNameString, Command),
    % system(Command, 0), !,
    name(Cmd, Command),
    system('sh', ['sh', '-c', Cmd], 0), !,
    name(NewFileName, NewFileNameString).
'$parse_filename2'(FileNameString, NewFileName, source) :-
    append("test -f ", FileNameString, Command),
    name(Cmd, Command),
    system('sh', ['sh', '-c', Cmd], 0), !,
    name(NewFileName, FileNameString).
    

'$type_file'(0'o, object).
'$type_file'(0'l, source).
