/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

/*
 * Built-in predicate: call/1
 */

/*
 * Resolve conjunctive, disjunctive and single call.
 */
call(Goals):-
    '$label'(Label),
    '$call'(Goals, Label).

'$call'(Goal, _) :-
    var(Goal),
    !,
    error('Undefined predicate: '),
    errorln(Goal),
    fail.
'$call'((Goal1 , Goal2), Label) :-
    !,
    '$call'(Goal1, Label),
    '$call'(Goal2, Label).
'$call'((Goal1 ; Goal2), _) :-
    nonvar(Goal1),
    Goal1 = (Cond -> Predicate),
    !,
    '$label'(Label),
    '$call'(((Cond, !, Predicate); Goal2), Label).
'$call'((Goal1 ; Goal2), Label) :-
    !,
    (
	'$call'(Goal1, Label)
    ;
	'$call'(Goal2, Label)
    ).
'$call'('!', Label):-
    '$cut'(Label).
'$call'(Goal, Label) :-
    ( '$no_debugging'
      -> '$real_call'(Goal)
      ;  '$debug_call'(Goal)
    ).

'$no_debugging' :-
    ( '$getFlag'(debugging,off);
      '$getFlag'(debugpause,on);
      '$getFlag'(debugpermision, off)
    ), !.

'$real_call'((Atoms : Arg)):-
    '$atoms_to_atom'(Atoms, F),
    !,
    Goal =.. [F, Arg],
    ('$static_predicate'(F, 1, Address) ->
	'$goto'(Address, Goal)
    ;
    '$dynamic'(F/1) ->
	'$label'(Label),
	clause(Goal, Body),
	'$call'(Body, Label)
    ;
    '$no_debugging' ->
	fail
    ;
	debugpause((
	error( 'Undefined predicate: '),
	error( Atoms),
	put_error( 0'/), put_error( 0'1))),
	fail
    ).
'$real_call'(Goal):-
    functor(Goal, F, N),
    ('$static_predicate'(F, N, Address) ->
	'$goto'(Address, Goal)
    ;
    '$dynamic'(F/N) ->
	'$label'(Label),
	clause(Goal, Body),
	'$call'(Body, Label)
    ;
    '$no_debugging' ->
	fail
    ;
	debugpause((
	error( 'Undefined predicate: '),
	error( F),
	error( '/'),
	errorln( N))),
	fail
    ).
