/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

X is Y :-
    once((var(Y); integer(Y))),
    !,
    X = Y.
X is Y :-
    '$is'(Y, X).

'$is'(Y + Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$plus'(Y2, Z2, X).
'$is'(Y - Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$minus'(Y2, Z2, X).
'$is'(Y * Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$times'(Y2, Z2, X).
'$is'(Y / Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$divide'(Y2, Z2, X).
'$is'(Y // Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$divide'(Y2, Z2, X).	%integer division. But only implement integers
				%sofar anyway.
'$is'(Y mod Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$mod'(Y2, Z2, X).
'$is'(**(Y, Z), X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$power'(Y2, Z2, X).
'$is'(Y /\ Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$bitwise_and'(Y2, Z2, X).
'$is'(Y \/ Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$bitwise_or'(Y2, Z2, X).
'$is'(Y ^ Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$bitwise_xor'(Y2, Z2, X).
'$is'(Y << Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$shift_left'(Y2, Z2, X).
'$is'(Y >> Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$shift_right'(Y2, Z2, X).
'$is'(+ Y, X) :-
    !,
    X is Y.
'$is'(- Y, X) :-
    !,
    Y2 is Y,
    '$minus1'(Y2, X).
'$is'(\(Y), X) :-
    !,
    Y2 is Y,
    '$complement'(Y2, X).
'$is'(not(Y), X) :-
    !,
    Y2 is Y,
    '$not'(Y2, X).
'$is'(Y < Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$lt'(Y2, Z2, X).
'$is'(Y =< Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$leq'(Y2, Z2, X).
'$is'(Y > Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$gt'(Y2, Z2, X).
'$is'(Y >= Z, X) :-
    !,
    Y2 is Y,
    Z2 is Z,
    '$geq'(Y2, Z2, X).

divides(N, M, Div, Mod) :-
    Div is N / M,
    Mod is N mod M.

M < N :-
    M2 is M,
    N2 is N,
    '$less_than'(M2, N2).

M =< N :-
    M < N, !.
M =< N :-
    M2 is M,
    N2 is N,
    M2 == N2.

M > N :-
    M2 is M,
    N2 is N,
    \+ (M2 =< N2).

M >= N :-
    M2 is M,
    N2 is N,
    \+ (M2 < N2).
