/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "name_table.h"
#include "code_area.h"
#include "executable.h"
#include "index.h"
#include "link.h"
#include "load.h"
#include "main.h"
#include "options.h"
#include "pc.h"
#include "pred_table.h"
#include "query_code.h"
#include "string_table.h"

global	code	*pc;

/*----------------------------------------------------------------------------
    Combine a number of object files into the following areas (first pass)
	query_code
	code_area
	string_table
	name_table
	predicate_table	
    and resolve the references to strings and predicates in the query_code
    and the code_area to new entries in the atom and predicate tables,
    (second pass).

    Then dump the 5 areas out into the executable file.
----------------------------------------------------------------------------*/
global 	void
main(unsigned int argc, char **argv)
{
	int	i;
	index	*object_index;

	OPTIONS ("-i N -a N -p N -s N -o file.qx file.qo ... ")
		NUMBER  ('i', code_area_size)
		NUMBER  ('a', name_table_size)
		NUMBER  ('p', predicate_table_size)
		NUMBER  ('s', string_table_size)
		STRING  ('o', executable_filename)
	ENDOPTS

	if (argc < 2)
		usage();

	object_index = (index *) malloc((argc-1)*sizeof(index));

	initialise_code_area();
	initialise_string_table();
	initialise_name_table();
	insert_defaults_in_string_table();
	initialise_predicate_table();
	initialise_string_map();
	pc = code_area;


	/* first pass */
	argc--;		/* ignore call name */
	for (i = 0; i < argc; i++)
	{
		load_object_file(argv[i+1], object_index + i);
	}
	/* second pass */
	link_object(object_index, argc);
	dump_executable();
	exit(0);
}
