
/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */
#include "name_table.h"

global  char     root[50];
global  char     str[50];

/*----------------------------------------------------------------------------
find_root(name)      

    Find a root for meta variable name. 
    root = all characters from the string (name) before '_'
----------------------------------------------------------------------------*/
global char * 
find_root(char *name)
{
	int     i; 

        
        for (i = 0; (*name != '_') && (*name != '\0'); i++, name++) 
            root[i] = *name; 
        root[i] = '\0';

	return(root);

}

/*----------------------------------------------------------------------------
generate_new_name(root_name, next_free)  

    Create new name for variable of root_name, '_' and next_free 
    While variable with that name is in use do 
        increment next_free by 1
        create new name 
    Increment next_free by 1 
    Return new created name 

    Variable is in use if its name is in name table and value of 
    its name is not NULL

----------------------------------------------------------------------------*/
global char * 
generate_new_name(char *root_name, unsigned int *next_free)
{
         natural i;
         natural incr;
local    natural lookup_name_table(char *, int);
         
	  
         for ( sprintf(str, "%s_%d", root_name, *next_free);;
	       (*next_free)++, sprintf(str, "%s_%d", root_name, *next_free) )
         {
	     i = lookup_name_table(str, VARIABLE_W); 
             if (ValueOfName(name_table[i]) == NULL)
	     {
		 /* variable is not in use */
		 (*next_free)++;
		 return(str);
             }
          }

}
